package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Locale;
import org.hibernate.SessionFactory;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.search.util.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.jboss.logging.BasicLogger;
import org.hibernate.mapping.Value;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String hibernateSearchNotInitialized = "HSEARCH800001: Hibernate Search was not initialized.";
    protected String hibernateSearchNotInitialized$str() {
        return hibernateSearchNotInitialized;
    }
    @Override
    public final SearchException hibernateSearchNotInitialized() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSearchNotInitialized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedSearchHitType = "HSEARCH800002: Unexpected entity type for a query hit: %1$s. Expected one of %2$s.";
    protected String unexpectedSearchHitType$str() {
        return unexpectedSearchHitType;
    }
    @Override
    public final SearchException unexpectedSearchHitType(final Class<?> entityType, final java.util.Collection<? extends Class<?>> expectedTypes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedSearchHitType$str(), entityType, expectedTypes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownIndexingMode = "HSEARCH800003: Unknown indexing mode: %1$s";
    protected String unknownIndexingMode$str() {
        return unknownIndexingMode;
    }
    @Override
    public final SearchException unknownIndexingMode(final String indexingMode) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownIndexingMode$str(), indexingMode));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownPropertyForGetter = "HSEARCH800004: Could not retrieve metadata for type %1$s, property '%2$s' accessed through getter '%3$s'";
    protected String unknownPropertyForGetter$str() {
        return unknownPropertyForGetter;
    }
    @Override
    public final SearchException unknownPropertyForGetter(final Class<?> entityType, final String propertyName, final Getter getter) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownPropertyForGetter$str(), entityType, propertyName, getter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void configurationPropertyTrackingDisabled() {
        super.log.logf(FQCN, INFO, null, configurationPropertyTrackingDisabled$str());
    }
    private static final String configurationPropertyTrackingDisabled = "HSEARCH800005: Configuration property tracking is disabled; unused properties will not be logged.";
    protected String configurationPropertyTrackingDisabled$str() {
        return configurationPropertyTrackingDisabled;
    }
    @Override
    public final void configurationPropertyTrackingUnusedProperties(final java.util.Set<String> propertyKeys, final String disableWarningKey) {
        super.log.logf(FQCN, WARN, null, configurationPropertyTrackingUnusedProperties$str(), propertyKeys, disableWarningKey);
    }
    private static final String configurationPropertyTrackingUnusedProperties = "HSEARCH800006: Some properties in the Hibernate Search configuration were not used; there might be misspelled property keys in your configuration. Unused properties were: %1$s. To disable this warning, set the property '%2$s' to false.";
    protected String configurationPropertyTrackingUnusedProperties$str() {
        return configurationPropertyTrackingUnusedProperties;
    }
    private static final String unknownPathForDirtyChecking = "HSEARCH800007: Path '%2$s' on entity type '%1$s' cannot be resolved using Hibernate ORM metadata. Please check that this path points to a persisted value.";
    protected String unknownPathForDirtyChecking$str() {
        return unknownPathForDirtyChecking;
    }
    @Override
    public final SearchException unknownPathForDirtyChecking(final Class<?> entityType, final PojoModelPath path, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownPathForDirtyChecking$str(), entityType, path), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unreportedPathForDirtyChecking = "HSEARCH800008: Path '%2$s' on entity type '%1$s' can be resolved using Hibernate ORM metadata, but points to value '%3$s' that will never be reported as dirty by Hibernate ORM. Please check that this path points to a persisted value, and in particular not an embedded property.";
    protected String unreportedPathForDirtyChecking$str() {
        return unreportedPathForDirtyChecking;
    }
    @Override
    public final SearchException unreportedPathForDirtyChecking(final Class<?> entityType, final PojoModelPath path, final Value value) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unreportedPathForDirtyChecking$str(), entityType, path, value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidContainerValueExtractorForDirtyChecking = "HSEARCH800009: Container value extractor of type '%2$s' cannot be applied to Hibernate ORM metadata node of type '%1$s'.";
    protected String invalidContainerValueExtractorForDirtyChecking$str() {
        return invalidContainerValueExtractorForDirtyChecking;
    }
    @Override
    public final SearchException invalidContainerValueExtractorForDirtyChecking(final Class<?> ormMappingClass, final Class<? extends org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor> extractorClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContainerValueExtractorForDirtyChecking$str(), ormMappingClass, extractorClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFindReadableProperty = "HSEARCH800010: Unable to find a readable property '%2$s' on type '%1$s'.";
    protected String cannotFindReadableProperty$str() {
        return cannotFindReadableProperty;
    }
    @Override
    public final SearchException cannotFindReadableProperty(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindReadableProperty$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String usingDifferentSessionFactories = "HSEARCH800011: Mapping service cannot create a search manager using a different session factory. Expected: '%1$s'. In use: '%2$s'.";
    protected String usingDifferentSessionFactories$str() {
        return usingDifferentSessionFactories;
    }
    @Override
    public final SearchException usingDifferentSessionFactories(final SessionFactory expectedSessionFactory, final SessionFactory usedSessionFactory) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), usingDifferentSessionFactories$str(), expectedSessionFactory, usedSessionFactory));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorRetrievingPropertyTypeModel = "HSEARCH800012: Exception while retrieving property type model for '%1$s' on '%2$s'.";
    protected String errorRetrievingPropertyTypeModel$str() {
        return errorRetrievingPropertyTypeModel;
    }
    @Override
    public final SearchException errorRetrievingPropertyTypeModel(final String propertyModelName, final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> parentTypeModel, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingPropertyTypeModel$str(), propertyModelName, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(parentTypeModel)), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
