/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ContainedBean;
import org.hibernate.resource.beans.container.spi.ContainedBeanImplementor;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.search.engine.environment.bean.spi.BeanResolver;
import org.hibernate.search.util.impl.common.Closer;
import org.hibernate.search.util.impl.common.Contracts;

final class HibernateOrmBeanContainerBeanResolver
implements BeanResolver {
    private static final BeanContainer.LifecycleOptions LIFECYCLE_OPTIONS = new BeanContainer.LifecycleOptions(){

        public boolean canUseCachedReferences() {
            return false;
        }

        public boolean useJpaCompliantCreation() {
            return false;
        }
    };
    private final BeanContainer beanContainer;
    private final ConcurrentHashMap<ContainedBeanImplementor, Object> beansToCleanup = new ConcurrentHashMap();
    private final BeanResolver fallback;
    private final BeanInstanceProducer fallbackInstanceProducer;

    HibernateOrmBeanContainerBeanResolver(BeanContainer beanContainer, final BeanResolver fallback) {
        Contracts.assertNotNull((Object)beanContainer, (String)"beanContainer");
        this.beanContainer = beanContainer;
        this.fallback = fallback;
        this.fallbackInstanceProducer = new BeanInstanceProducer(){
            private final BeanResolver delegate;
            {
                this.delegate = fallback;
            }

            public <B> B produceBeanInstance(Class<B> aClass) {
                return (B)this.delegate.resolve(aClass, aClass);
            }

            public <B> B produceBeanInstance(String s, Class<B> aClass) {
                return (B)this.delegate.resolve(s, aClass);
            }
        };
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(ContainedBeanImplementor::release, (Iterable)this.beansToCleanup.keySet());
            closer.push(BeanResolver::close, (Object)this.fallback);
        }
    }

    public <T> T resolve(Class<?> typeReference, Class<T> expectedClass) {
        ContainedBean containedBean = this.beanContainer.getBean(typeReference, LIFECYCLE_OPTIONS, this.fallbackInstanceProducer);
        this.register(containedBean);
        return expectedClass.cast(containedBean.getBeanInstance());
    }

    public <T> T resolve(String nameReference, Class<T> expectedClass) {
        ContainedBean containedBean = this.beanContainer.getBean(nameReference, expectedClass, LIFECYCLE_OPTIONS, this.fallbackInstanceProducer);
        this.register(containedBean);
        return (T)containedBean.getBeanInstance();
    }

    public <T> T resolve(String nameReference, Class<?> typeReference, Class<T> expectedClass) {
        ContainedBean containedBean = this.beanContainer.getBean(nameReference, typeReference, LIFECYCLE_OPTIONS, this.fallbackInstanceProducer);
        this.register(containedBean);
        return expectedClass.cast(containedBean.getBeanInstance());
    }

    private void register(ContainedBean<?> containedBean) {
        if (containedBean instanceof ContainedBeanImplementor) {
            this.beansToCleanup.put((ContainedBeanImplementor)containedBean, containedBean);
        }
    }
}

