/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchSessionFactoryObserver;
import org.hibernate.search.mapper.orm.cfg.IndexingStrategyConfiguration;
import org.hibernate.search.mapper.orm.cfg.SearchOrmSettings;
import org.hibernate.search.mapper.orm.cfg.impl.HibernateOrmConfigurationPropertySource;
import org.hibernate.search.mapper.orm.event.impl.FullTextIndexEventListener;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.spi.EnvironmentSynchronizer;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class HibernateSearchIntegrator
implements Integrator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Boolean> AUTOREGISTER_LISTENERS = ConfigurationProperty.forKey((String)"autoregister_listeners").asBoolean().withDefault((Object)true).build();
    private static final ConfigurationProperty<IndexingStrategyConfiguration> INDEXING_MODE = ConfigurationProperty.forKey((String)"indexing_strategy").as(IndexingStrategyConfiguration.class, IndexingStrategyConfiguration::fromExternalRepresentation).withDefault((Object)SearchOrmSettings.Defaults.INDEXING_STRATEGY).build();
    private static final ConfigurationProperty<Boolean> DIRTY_PROCESSING_ENABLED = ConfigurationProperty.forKey((String)"enable_dirty_check").asBoolean().withDefault((Object)true).build();

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        ConfigurationService configurationService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        HibernateOrmConfigurationPropertySource propertySource = new HibernateOrmConfigurationPropertySource(configurationService);
        JndiService namingService = (JndiService)serviceRegistry.getService(JndiService.class);
        if (!((Boolean)AUTOREGISTER_LISTENERS.get((ConfigurationPropertySource)propertySource)).booleanValue()) {
            log.debug("Skipping Hibernate Search event listener auto registration");
            return;
        }
        FullTextIndexEventListener fullTextIndexEventListener = new FullTextIndexEventListener(IndexingStrategyConfiguration.EVENT.equals(INDEXING_MODE.get((ConfigurationPropertySource)propertySource)), (Boolean)DIRTY_PROCESSING_ENABLED.get((ConfigurationPropertySource)propertySource));
        this.registerHibernateSearchEventListener(fullTextIndexEventListener, serviceRegistry);
        ClassLoaderService hibernateOrmClassLoaderService = (ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class);
        ServiceBinding environmentSynchronizerBinding = serviceRegistry.locateServiceBinding(EnvironmentSynchronizer.class);
        ServiceBinding managedBeanRegistryServiceBinding = serviceRegistry.locateServiceBinding(ManagedBeanRegistry.class);
        HibernateSearchSessionFactoryObserver observer = new HibernateSearchSessionFactoryObserver(metadata, propertySource, fullTextIndexEventListener, hibernateOrmClassLoaderService, environmentSynchronizerBinding == null ? null : (EnvironmentSynchronizer)serviceRegistry.getService(EnvironmentSynchronizer.class), managedBeanRegistryServiceBinding == null ? null : (ManagedBeanRegistry)serviceRegistry.getService(ManagedBeanRegistry.class), namingService);
        sessionFactory.addObserver((SessionFactoryObserver)observer);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private void registerHibernateSearchEventListener(FullTextIndexEventListener eventListener, SessionFactoryServiceRegistry serviceRegistry) {
        EventListenerRegistry listenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy((DuplicationStrategy)new KeepIfSameClassDuplicationStrategy(FullTextIndexEventListener.class));
        listenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_RECREATE, (Object[])new PostCollectionRecreateEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_REMOVE, (Object[])new PostCollectionRemoveEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_UPDATE, (Object[])new PostCollectionUpdateEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.FLUSH, (Object[])new FlushEventListener[]{eventListener});
    }

    public static class KeepIfSameClassDuplicationStrategy
    implements DuplicationStrategy {
        private final Class<?> checkClass;

        public KeepIfSameClassDuplicationStrategy(Class<?> checkClass) {
            this.checkClass = checkClass;
        }

        public boolean areMatch(Object listener, Object original) {
            return this.checkClass == original.getClass() && this.checkClass == listener.getClass();
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    }
}

