/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.cfg;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

public enum IndexingStrategyConfiguration {
    EVENT("event"),
    MANUAL("manual");

    private static Log LOG;
    private String externalRepresentation;

    private IndexingStrategyConfiguration(String externalRepresentation) {
        this.externalRepresentation = externalRepresentation;
    }

    public static IndexingStrategyConfiguration fromExternalRepresentation(String indexingMode) {
        if (EVENT.toExternalRepresentation().equals(indexingMode)) {
            return EVENT;
        }
        if (MANUAL.toExternalRepresentation().equals(indexingMode)) {
            return MANUAL;
        }
        throw LOG.unknownIndexingMode(indexingMode);
    }

    public String toExternalRepresentation() {
        return this.externalRepresentation;
    }

    static {
        LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    }
}

