/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.cfg.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.Set;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.UnusedPropertyTrackingConfigurationPropertySource;
import org.hibernate.search.mapper.orm.cfg.impl.HibernateOrmConfigurationServicePropertySource;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class HibernateOrmConfigurationPropertySource
implements ConfigurationPropertySource {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Boolean> ENABLE_CONFIGURATION_PROPERTY_TRACKING = ConfigurationProperty.forKey((String)"enable_configuration_property_tracking").asBoolean().withDefault((Object)true).build();
    private final UnusedPropertyTrackingConfigurationPropertySource unusedPropertyTrackingPropertySource;
    private final ConfigurationPropertySource delegate;

    public HibernateOrmConfigurationPropertySource(ConfigurationService configurationService) {
        HibernateOrmConfigurationServicePropertySource serviceSource = new HibernateOrmConfigurationServicePropertySource(configurationService);
        ConfigurationPropertySource maskedSource = serviceSource.withMask("hibernate.search");
        if (((Boolean)ENABLE_CONFIGURATION_PROPERTY_TRACKING.get(maskedSource)).booleanValue()) {
            Set<String> availablePropertyKeys = serviceSource.resolveAll("hibernate.search.");
            this.unusedPropertyTrackingPropertySource = new UnusedPropertyTrackingConfigurationPropertySource(maskedSource, availablePropertyKeys);
            ENABLE_CONFIGURATION_PROPERTY_TRACKING.get((ConfigurationPropertySource)this.unusedPropertyTrackingPropertySource);
            this.delegate = this.unusedPropertyTrackingPropertySource;
        } else {
            log.configurationPropertyTrackingDisabled();
            this.unusedPropertyTrackingPropertySource = null;
            this.delegate = maskedSource;
        }
    }

    public Optional<?> get(String key) {
        return this.delegate.get(key);
    }

    public Optional<String> resolve(String key) {
        return this.delegate.resolve(key);
    }

    public void afterBootstrap() {
        Set unusedPropertyKeys;
        if (this.unusedPropertyTrackingPropertySource != null && !(unusedPropertyKeys = this.unusedPropertyTrackingPropertySource.getUnusedPropertyKeys()).isEmpty()) {
            log.configurationPropertyTrackingUnusedProperties(unusedPropertyKeys, ENABLE_CONFIGURATION_PROPERTY_TRACKING.resolveOrRaw((ConfigurationPropertySource)this));
        }
    }
}

