/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.cfg.impl;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;

class HibernateOrmConfigurationServicePropertySource
implements ConfigurationPropertySource {
    private static final ConfigurationService.Converter<Object> OBJECT_CONVERTER = value -> value;
    private final ConfigurationService configurationService;

    HibernateOrmConfigurationServicePropertySource(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public Optional<?> get(String key) {
        return Optional.ofNullable(this.configurationService.getSetting(key, OBJECT_CONVERTER));
    }

    public Optional<String> resolve(String key) {
        return Optional.of(key);
    }

    public Set<String> resolveAll(String prefix) {
        HashSet<String> hibernateSearchPropertyKeys = new HashSet<String>();
        for (Object key : this.configurationService.getSettings().keySet()) {
            String stringKey;
            if (!(key instanceof String) || !(stringKey = (String)key).startsWith(prefix)) continue;
            hibernateSearchPropertyKeys.add(stringKey);
        }
        return hibernateSearchPropertyKeys;
    }
}

