/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.impl;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.hql.internal.QueryExecutionRequestException;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.AbstractProducedQuery;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.search.engine.search.SearchQuery;
import org.hibernate.search.mapper.orm.jpa.FullTextQuery;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableObjectLoadingOptions;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

public class FullTextQueryImpl<R>
extends AbstractProducedQuery<R>
implements org.hibernate.search.mapper.orm.hibernate.FullTextQuery<R> {
    private final SearchQuery<R> searchQuery;
    private final MutableObjectLoadingOptions loadingOptions;
    private Integer firstResult;
    private Integer maxResults;

    public FullTextQueryImpl(SearchQuery<R> searchQuery, SessionImplementor sessionImplementor, MutableObjectLoadingOptions loadingOptions) {
        super((SharedSessionContractImplementor)sessionImplementor, (ParameterMetadata)new ParameterMetadataImpl(null, null));
        this.searchQuery = searchQuery;
        this.loadingOptions = loadingOptions;
    }

    public <T> T unwrap(Class<T> type) {
        if (type.equals(FullTextQuery.class)) {
            return (T)this;
        }
        if (type.equals(org.hibernate.search.mapper.orm.hibernate.FullTextQuery.class)) {
            return (T)this;
        }
        if (type.equals(SearchQuery.class)) {
            return (T)this.searchQuery;
        }
        return (T)super.unwrap(type);
    }

    public List<R> getResultList() {
        return this.list();
    }

    public Iterator<R> iterate() {
        throw this.resultStreamingNotImplemented();
    }

    public ScrollableResultsImplementor scroll() {
        throw this.resultStreamingNotImplemented();
    }

    public ScrollableResultsImplementor scroll(ScrollMode scrollMode) {
        throw this.resultStreamingNotImplemented();
    }

    private UnsupportedOperationException resultStreamingNotImplemented() {
        return new UnsupportedOperationException("Not implemented yet");
    }

    public List<R> list() {
        try {
            return this.doHibernateSearchList();
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    protected List<R> doHibernateSearchList() {
        List results = this.searchQuery.execute().getHits();
        return results;
    }

    public FullTextQueryImpl<R> setMaxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException("Negative (" + maxResults + ") parameter passed in to setMaxResults");
        }
        this.searchQuery.setMaxResults(Long.valueOf(maxResults));
        this.maxResults = maxResults;
        return this;
    }

    public int getMaxResults() {
        return this.maxResults == null || this.maxResults == -1 ? Integer.MAX_VALUE : this.maxResults;
    }

    public FullTextQueryImpl<R> setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("Negative (" + firstResult + ") parameter passed in to setFirstResult");
        }
        this.searchQuery.setFirstResult(Long.valueOf(firstResult));
        this.firstResult = firstResult;
        return this;
    }

    public int getFirstResult() {
        return this.firstResult == null ? 0 : this.firstResult;
    }

    public FullTextQueryImpl<R> setHint(String hintName, Object value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Map<String, Object> getHints() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public <P> FullTextQueryImpl<R> setParameter(Parameter<P> tParameter, P t) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl<R> setParameter(Parameter<Calendar> calendarParameter, Calendar calendar, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl<R> setParameter(Parameter<Date> dateParameter, Date date, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl<R> setParameter(String name, Object value) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl<R> setParameter(String name, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl<R> setParameter(int position, Object value) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl<R> setParameter(int position, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Set<Parameter<?>> getParameters() {
        return Collections.EMPTY_SET;
    }

    protected QueryParameterBindings getQueryParameterBindings() {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public QueryParameter<?> getParameter(String name) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public QueryParameter<?> getParameter(int position) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public <T> QueryParameter<T> getParameter(String name, Class<T> type) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public <T> QueryParameter<T> getParameter(int position, Class<T> type) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public boolean isBound(Parameter<?> param) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public <T> T getParameterValue(Parameter<T> param) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Object getParameterValue(String name) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Object getParameterValue(int position) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl<R> setFlushMode(FlushModeType flushModeType) {
        return (FullTextQueryImpl)super.setFlushMode(flushModeType);
    }

    public FullTextQueryImpl<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        this.loadingOptions.setFetchSize(fetchSize);
        return this;
    }

    public FullTextQueryImpl<R> setLockOptions(LockOptions lockOptions) {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    @Deprecated
    public FullTextQueryImpl<R> setResultTransformer(ResultTransformer transformer) {
        super.setResultTransformer(transformer);
        throw this.resultTransformerNotImplemented();
    }

    private UnsupportedOperationException resultTransformerNotImplemented() {
        return new UnsupportedOperationException("Not implemented yet");
    }

    public FullTextQueryImpl<R> setLockMode(LockModeType lockModeType) {
        throw new UnsupportedOperationException("lock modes not supported in fullText queries");
    }

    public LockModeType getLockMode() {
        throw new UnsupportedOperationException("lock modes not supported in fullText queries");
    }

    public LockOptions getLockOptions() {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    public int executeUpdate() {
        throw new UnsupportedOperationException("executeUpdate is not supported in Hibernate Search queries");
    }

    public FullTextQueryImpl<R> setLockMode(String alias, LockMode lockMode) {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    public FullTextQueryImpl<R> setTimeout(int timeout) {
        throw this.timeoutNotImplementedYet();
    }

    private UnsupportedOperationException timeoutNotImplementedYet() {
        return new UnsupportedOperationException("Not implemented yet");
    }

    public String getQueryString() {
        return this.searchQuery.getQueryString();
    }

    protected boolean isNativeQuery() {
        return false;
    }

    @Deprecated
    public Type[] getReturnTypes() {
        throw new UnsupportedOperationException("getReturnTypes() is not implemented in Hibernate Search queries");
    }

    @Deprecated
    public String[] getReturnAliases() {
        throw new UnsupportedOperationException("getReturnAliases() is not implemented in Hibernate Search queries");
    }

    @Deprecated
    public FullTextQueryImpl<R> setEntity(int position, Object val) {
        throw new UnsupportedOperationException("setEntity(int,Object) is not implemented in Hibernate Search queries");
    }

    @Deprecated
    public FullTextQueryImpl<R> setEntity(String name, Object val) {
        throw new UnsupportedOperationException("setEntity(String,Object) is not implemented in Hibernate Search queries");
    }

    public String toString() {
        return "FullTextQueryImpl(" + this.getQueryString() + ")";
    }
}

