/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Collection;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.hibernate.mapping.Value;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.SearchException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=800000, max=809999)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_1 = 0;
    public static final int ID_OFFSET_2 = 800000;

    @Message(id=800001, value="Hibernate Search was not initialized.")
    public SearchException hibernateSearchNotInitialized();

    @Message(id=800002, value="Unexpected entity type for a query hit: %1$s. Expected one of %2$s.")
    public SearchException unexpectedSearchHitType(Class<?> var1, Collection<? extends Class<?>> var2);

    @Message(id=800003, value="Unknown indexing mode: %1$s")
    public SearchException unknownIndexingMode(String var1);

    @Message(id=800004, value="Could not retrieve metadata for type %1$s, property '%2$s' accessed through getter '%3$s'")
    public SearchException unknownPropertyForGetter(Class<?> var1, String var2, Getter var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=800005, value="Configuration property tracking is disabled; unused properties will not be logged.")
    public void configurationPropertyTrackingDisabled();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=800006, value="Some properties in the Hibernate Search configuration were not used; there might be misspelled property keys in your configuration. Unused properties were: %1$s. To disable this warning, set the property '%2$s' to false.")
    public void configurationPropertyTrackingUnusedProperties(Set<String> var1, String var2);

    @Message(id=800007, value="Path '%2$s' on entity type '%1$s' cannot be resolved using Hibernate ORM metadata. Please check that this path points to a persisted value.")
    public SearchException unknownPathForDirtyChecking(Class<?> var1, PojoModelPath var2, @Cause Exception var3);

    @Message(id=800008, value="Path '%2$s' on entity type '%1$s' can be resolved using Hibernate ORM metadata, but points to value '%3$s' that will never be reported as dirty by Hibernate ORM. Please check that this path points to a persisted value, and in particular not an embedded property.")
    public SearchException unreportedPathForDirtyChecking(Class<?> var1, PojoModelPath var2, Value var3);

    @Message(id=800009, value="Container value extractor of type '%2$s' cannot be applied to Hibernate ORM metadata node of type '%1$s'.")
    public SearchException invalidContainerValueExtractorForDirtyChecking(Class<?> var1, Class<? extends ContainerValueExtractor> var2);

    @Message(id=800010, value="Unable to find a readable property '%2$s' on type '%1$s'.")
    public SearchException cannotFindReadableProperty(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, String var2);

    @Message(id=800011, value="Mapping service cannot create a search manager using a different session factory. Expected: '%1$s'. In use: '%2$s'.")
    public SearchException usingDifferentSessionFactories(SessionFactory var1, SessionFactory var2);

    @Message(id=800012, value="Exception while retrieving property type model for '%1$s' on '%2$s'.")
    public SearchException errorRetrievingPropertyTypeModel(String var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var2, @Cause Exception var3);
}

