/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.hibernate.mapping.Value;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.SearchException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String hibernateSearchNotInitialized = "HSEARCH800001: Hibernate Search was not initialized.";
    private static final String unexpectedSearchHitType = "HSEARCH800002: Unexpected entity type for a query hit: %1$s. Expected one of %2$s.";
    private static final String unknownIndexingMode = "HSEARCH800003: Unknown indexing mode: %1$s";
    private static final String unknownPropertyForGetter = "HSEARCH800004: Could not retrieve metadata for type %1$s, property '%2$s' accessed through getter '%3$s'";
    private static final String configurationPropertyTrackingDisabled = "HSEARCH800005: Configuration property tracking is disabled; unused properties will not be logged.";
    private static final String configurationPropertyTrackingUnusedProperties = "HSEARCH800006: Some properties in the Hibernate Search configuration were not used; there might be misspelled property keys in your configuration. Unused properties were: %1$s. To disable this warning, set the property '%2$s' to false.";
    private static final String unknownPathForDirtyChecking = "HSEARCH800007: Path '%2$s' on entity type '%1$s' cannot be resolved using Hibernate ORM metadata. Please check that this path points to a persisted value.";
    private static final String unreportedPathForDirtyChecking = "HSEARCH800008: Path '%2$s' on entity type '%1$s' can be resolved using Hibernate ORM metadata, but points to value '%3$s' that will never be reported as dirty by Hibernate ORM. Please check that this path points to a persisted value, and in particular not an embedded property.";
    private static final String invalidContainerValueExtractorForDirtyChecking = "HSEARCH800009: Container value extractor of type '%2$s' cannot be applied to Hibernate ORM metadata node of type '%1$s'.";
    private static final String cannotFindReadableProperty = "HSEARCH800010: Unable to find a readable property '%2$s' on type '%1$s'.";
    private static final String usingDifferentSessionFactories = "HSEARCH800011: Mapping service cannot create a search manager using a different session factory. Expected: '%1$s'. In use: '%2$s'.";
    private static final String errorRetrievingPropertyTypeModel = "HSEARCH800012: Exception while retrieving property type model for '%1$s' on '%2$s'.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String hibernateSearchNotInitialized$str() {
        return hibernateSearchNotInitialized;
    }

    @Override
    public final SearchException hibernateSearchNotInitialized() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSearchNotInitialized$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedSearchHitType$str() {
        return unexpectedSearchHitType;
    }

    @Override
    public final SearchException unexpectedSearchHitType(Class<?> entityType, Collection<? extends Class<?>> expectedTypes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedSearchHitType$str(), entityType, expectedTypes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownIndexingMode$str() {
        return unknownIndexingMode;
    }

    @Override
    public final SearchException unknownIndexingMode(String indexingMode) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownIndexingMode$str(), indexingMode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownPropertyForGetter$str() {
        return unknownPropertyForGetter;
    }

    @Override
    public final SearchException unknownPropertyForGetter(Class<?> entityType, String propertyName, Getter getter) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownPropertyForGetter$str(), entityType, propertyName, getter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void configurationPropertyTrackingDisabled() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.configurationPropertyTrackingDisabled$str(), new Object[0]);
    }

    protected String configurationPropertyTrackingDisabled$str() {
        return configurationPropertyTrackingDisabled;
    }

    @Override
    public final void configurationPropertyTrackingUnusedProperties(Set<String> propertyKeys, String disableWarningKey) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.configurationPropertyTrackingUnusedProperties$str(), propertyKeys, (Object)disableWarningKey);
    }

    protected String configurationPropertyTrackingUnusedProperties$str() {
        return configurationPropertyTrackingUnusedProperties;
    }

    protected String unknownPathForDirtyChecking$str() {
        return unknownPathForDirtyChecking;
    }

    @Override
    public final SearchException unknownPathForDirtyChecking(Class<?> entityType, PojoModelPath path, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownPathForDirtyChecking$str(), entityType, path), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unreportedPathForDirtyChecking$str() {
        return unreportedPathForDirtyChecking;
    }

    @Override
    public final SearchException unreportedPathForDirtyChecking(Class<?> entityType, PojoModelPath path, Value value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unreportedPathForDirtyChecking$str(), entityType, path, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidContainerValueExtractorForDirtyChecking$str() {
        return invalidContainerValueExtractorForDirtyChecking;
    }

    @Override
    public final SearchException invalidContainerValueExtractorForDirtyChecking(Class<?> ormMappingClass, Class<? extends ContainerValueExtractor> extractorClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidContainerValueExtractorForDirtyChecking$str(), ormMappingClass, extractorClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindReadableProperty$str() {
        return cannotFindReadableProperty;
    }

    @Override
    public final SearchException cannotFindReadableProperty(PojoRawTypeModel<?> typeModel, String propertyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindReadableProperty$str(), new PojoTypeModelFormatter(typeModel), propertyName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String usingDifferentSessionFactories$str() {
        return usingDifferentSessionFactories;
    }

    @Override
    public final SearchException usingDifferentSessionFactories(SessionFactory expectedSessionFactory, SessionFactory usedSessionFactory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.usingDifferentSessionFactories$str(), expectedSessionFactory, usedSessionFactory));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorRetrievingPropertyTypeModel$str() {
        return errorRetrievingPropertyTypeModel;
    }

    @Override
    public final SearchException errorRetrievingPropertyTypeModel(String propertyModelName, PojoRawTypeModel<?> parentTypeModel, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingPropertyTypeModel$str(), propertyModelName, new PojoTypeModelFormatter(parentTypeModel)), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

