/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmMappingDefinitionContainerContext;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmSearchMappingConfigurer;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingFactory;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMetatadaContributor;
import org.hibernate.search.mapper.orm.mapping.spi.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingDefinitionContext;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingInitiator;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.util.impl.common.StreamHelper;

public class HibernateOrmMappingInitiator
extends AbstractPojoMappingInitiator<HibernateOrmMapping>
implements HibernateOrmMappingDefinitionContainerContext {
    private static final ConfigurationProperty<Boolean> ENABLE_ANNOTATION_MAPPING = ConfigurationProperty.forKey((String)"enable_annotation_mapping").asBoolean().withDefault((Object)true).build();
    private final Metadata metadata;
    private final HibernateOrmBootstrapIntrospector introspector;

    public static HibernateOrmMappingInitiator create(Metadata metadata, SessionFactoryImplementor sessionFactoryImplementor) {
        HibernateOrmBootstrapIntrospector introspector = new HibernateOrmBootstrapIntrospector(metadata, sessionFactoryImplementor);
        return new HibernateOrmMappingInitiator(metadata, introspector, sessionFactoryImplementor);
    }

    private HibernateOrmMappingInitiator(Metadata metadata, HibernateOrmBootstrapIntrospector introspector, SessionFactoryImplementor sessionFactoryImplementor) {
        super((PojoMappingFactory)new HibernateOrmMappingFactory(sessionFactoryImplementor), (PojoBootstrapIntrospector)introspector);
        this.metadata = metadata;
        this.introspector = introspector;
        this.setMultiTenancyEnabled(!MultiTenancyStrategy.NONE.equals((Object)sessionFactoryImplementor.getSessionFactoryOptions().getMultiTenancyStrategy()));
    }

    public void configure(MappingBuildContext buildContext, ConfigurationPropertySource propertySource, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        Map persistentClasses = (Map)this.metadata.getEntityBindings().stream().filter(persistentClass -> persistentClass.getMappedClass() != null).collect(StreamHelper.toMap(PersistentClass::getEntityName, Function.identity(), TreeMap::new));
        this.addConfigurationContributor(new HibernateOrmMetatadaContributor(this.introspector, persistentClasses));
        boolean enableAnnotationMapping = (Boolean)ENABLE_ANNOTATION_MAPPING.get(propertySource);
        if (enableAnnotationMapping) {
            this.setAnnotatedTypeDiscoveryEnabled(true);
            AnnotationMappingDefinitionContext annotationMapping = this.annotationMapping();
            for (PersistentClass persistentClass2 : persistentClasses.values()) {
                annotationMapping.add(persistentClass2.getMappedClass());
            }
        }
        BeanProvider beanProvider = buildContext.getServiceManager().getBeanProvider();
        ConfigurationProperty mappingConfigurerProperty = ConfigurationProperty.forKey((String)"mapping_configurer").as(HibernateOrmSearchMappingConfigurer.class, reference -> (HibernateOrmSearchMappingConfigurer)beanProvider.getBean(reference, HibernateOrmSearchMappingConfigurer.class)).build();
        ((Optional)mappingConfigurerProperty.get(propertySource)).ifPresent(configurer -> configurer.configure(this));
        super.configure(buildContext, propertySource, configurationCollector);
    }
}

