/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmAssociationEmbeddedMetadataContributor;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmAssociationInverseSideMetadataContributor;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmEntityTypeMetadataContributor;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.builtin.ArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.CollectionElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.MapValueExtractor;
import org.hibernate.search.mapper.pojo.mapping.building.spi.ErrorCollectingPojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

public final class HibernateOrmMetatadaContributor
implements PojoMappingConfigurationContributor {
    private final HibernateOrmBootstrapIntrospector introspector;
    private final java.util.Map<String, PersistentClass> persistentClasses;

    public HibernateOrmMetatadaContributor(HibernateOrmBootstrapIntrospector introspector, java.util.Map<String, PersistentClass> persistentClasses) {
        this.introspector = introspector;
        this.persistentClasses = persistentClasses;
    }

    public void configure(MappingBuildContext buildContext, ConfigurationPropertySource propertySource, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        PropertyDelegatesCollector delegatesCollector = new PropertyDelegatesCollector();
        for (PersistentClass persistentClass : this.persistentClasses.values()) {
            Class clazz = persistentClass.getMappedClass();
            PojoRawTypeModel typeModel = this.introspector.getTypeModel(clazz);
            this.collectPropertyDelegates(delegatesCollector, clazz, persistentClass.getPropertyIterator());
            String identifierPropertyName = persistentClass.getIdentifierProperty().getName();
            List<PojoTypeMetadataContributor> delegates = delegatesCollector.buildAndRemove(clazz);
            configurationCollector.collectContributor(typeModel, (Object)new ErrorCollectingPojoTypeMetadataContributor().add((PojoTypeMetadataContributor)new HibernateOrmEntityTypeMetadataContributor(persistentClass, identifierPropertyName)).addAll(delegates));
        }
        for (Map.Entry entry : delegatesCollector.buildRemaining().entrySet()) {
            PojoRawTypeModel typeModel = this.introspector.getTypeModel((Class)entry.getKey());
            List delegates = (List)entry.getValue();
            if (delegates.isEmpty()) continue;
            configurationCollector.collectContributor(typeModel, (Object)new ErrorCollectingPojoTypeMetadataContributor().addAll((Collection)delegates));
        }
    }

    private void collectPropertyDelegates(PropertyDelegatesCollector collector, Class<?> javaClass, Iterator propertyIterator) {
        collector.markAsSeen(javaClass);
        ArrayList<Property> properties = new ArrayList<Property>();
        while (propertyIterator.hasNext()) {
            properties.add((Property)propertyIterator.next());
        }
        properties.sort(Comparator.comparing(Property::getName));
        for (Property property : properties) {
            this.collectPropertyMetadataContributors(collector, javaClass, property);
        }
    }

    private void collectPropertyMetadataContributors(PropertyDelegatesCollector collector, Class<?> javaClass, Property property) {
        Value value = property.getValue();
        if (value instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collectionValue = (org.hibernate.mapping.Collection)value;
            Value element = collectionValue.getElement();
            String referencedEntityName = this.getReferencedEntityName(element);
            String mappedByPath = collectionValue.getMappedByProperty();
            if (referencedEntityName != null && mappedByPath != null && !mappedByPath.isEmpty()) {
                collector.collect(javaClass, new HibernateOrmAssociationInverseSideMetadataContributor(property.getName(), this.getExtractorPath((Value)collectionValue), this.resolveMappedByPath(referencedEntityName, mappedByPath)));
            }
        } else if (value instanceof ToOne) {
            ToOne toOneValue = (ToOne)value;
            String referencedEntityName = toOneValue.getReferencedEntityName();
            String mappedByPath = toOneValue.getReferencedPropertyName();
            if (mappedByPath != null && !mappedByPath.isEmpty()) {
                collector.collect(javaClass, new HibernateOrmAssociationInverseSideMetadataContributor(property.getName(), this.getExtractorPath((Value)toOneValue), this.resolveMappedByPath(referencedEntityName, mappedByPath)));
            }
        } else if (value instanceof Component) {
            collector.collect(javaClass, new HibernateOrmAssociationEmbeddedMetadataContributor(property.getName(), this.getExtractorPath(value)));
            Component componentValue = (Component)value;
            Class componentClass = componentValue.getComponentClass();
            if (!collector.hasSeen(componentClass)) {
                this.collectPropertyDelegates(collector, componentClass, componentValue.getPropertyIterator());
            }
        }
    }

    private String getReferencedEntityName(Value element) {
        if (element instanceof OneToMany) {
            return ((OneToMany)element).getReferencedEntityName();
        }
        if (element instanceof ToOne) {
            return ((ToOne)element).getReferencedEntityName();
        }
        return null;
    }

    private PojoModelPathValueNode resolveMappedByPath(String inverseSideEntity, String mappedByPath) {
        PojoModelPathValueNode inverseSideValuePath;
        StringTokenizer tokenizer = new StringTokenizer(mappedByPath, ".", false);
        String rootPropertyName = tokenizer.nextToken();
        PojoModelPathPropertyNode inverseSidePropertyPath = PojoModelPath.fromRoot((String)rootPropertyName);
        Property property = this.persistentClasses.get(inverseSideEntity).getProperty(rootPropertyName);
        do {
            Value value = property.getValue();
            inverseSideValuePath = inverseSidePropertyPath.value(this.getExtractorPath(value));
            if (tokenizer.hasMoreTokens()) {
                Component component = (Component)value;
                String propertyName = tokenizer.nextToken();
                property = component.getProperty(propertyName);
                inverseSidePropertyPath = inverseSideValuePath.property(propertyName);
                continue;
            }
            property = null;
        } while (property != null);
        return inverseSideValuePath;
    }

    private ContainerValueExtractorPath getExtractorPath(Value value) {
        if (value instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collectionValue = (org.hibernate.mapping.Collection)value;
            Class<? extends ContainerValueExtractor> extractorClass = this.getExtractorClass(collectionValue);
            return ContainerValueExtractorPath.explicitExtractor(extractorClass);
        }
        return ContainerValueExtractorPath.noExtractors();
    }

    private Class<? extends ContainerValueExtractor> getExtractorClass(org.hibernate.mapping.Collection collectionValue) {
        if (collectionValue instanceof Array) {
            return ArrayElementExtractor.class;
        }
        if (collectionValue instanceof Map) {
            return MapValueExtractor.class;
        }
        return CollectionElementExtractor.class;
    }

    private static class PropertyDelegatesCollector {
        private final java.util.Map<Class<?>, List<PojoTypeMetadataContributor>> result = new LinkedHashMap();

        private PropertyDelegatesCollector() {
        }

        public void markAsSeen(Class<?> clazz) {
            this.getList(clazz);
        }

        public boolean hasSeen(Class<?> clazz) {
            return this.result.containsKey(clazz);
        }

        public void collect(Class<?> clazz, PojoTypeMetadataContributor contributor) {
            this.getList(clazz).add(contributor);
        }

        public List<PojoTypeMetadataContributor> buildAndRemove(Class<?> clazz) {
            List<PojoTypeMetadataContributor> built = this.getList(clazz);
            this.result.remove(clazz);
            return built;
        }

        public java.util.Map<Class<?>, List<PojoTypeMetadataContributor>> buildRemaining() {
            return this.result;
        }

        private List<PojoTypeMetadataContributor> getList(Class<?> clazz) {
            return this.result.computeIfAbsent(clazz, ignored -> new ArrayList());
        }
    }
}

