/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractor;
import org.hibernate.search.mapper.pojo.extractor.ContainerValueExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.builtin.ArrayElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.CollectionElementExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.MapKeyExtractor;
import org.hibernate.search.mapper.pojo.extractor.builtin.MapValueExtractor;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.path.spi.StringSetPojoPathFilter;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.util.impl.common.CollectionHelper;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class HibernateOrmPathFilterFactory
implements PojoPathFilterFactory<Set<String>> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PersistentClass persistentClass;

    public HibernateOrmPathFilterFactory(PersistentClass persistentClass) {
        this.persistentClass = persistentClass;
    }

    public PojoPathFilter<Set<String>> create(Set<PojoModelPathValueNode> paths) {
        LinkedHashSet pathsAsStrings = CollectionHelper.newLinkedHashSet((int)paths.size());
        for (PojoModelPathValueNode path : paths) {
            this.addDirtyPathStringRepresentations(pathsAsStrings, path);
        }
        return new StringSetPojoPathFilter((Set)pathsAsStrings);
    }

    private void addDirtyPathStringRepresentations(Set<String> pathsAsStrings, PojoModelPathValueNode path) {
        Optional<Value> valueOptional = this.addDirtyPathStringRepresentationsRecursively(pathsAsStrings, path, true);
        if (valueOptional.isPresent()) {
            Value value = valueOptional.get();
            throw log.unreportedPathForDirtyChecking(this.persistentClass.getMappedClass(), (PojoModelPath)path, value);
        }
    }

    private Optional<Value> addDirtyPathStringRepresentationsRecursively(Set<String> pathsAsStrings, PojoModelPathValueNode path, boolean isWholePath) {
        Property property;
        PojoModelPathPropertyNode propertyNode = path.getParent();
        PojoModelPathValueNode propertyNodeParent = propertyNode.getParent();
        if (propertyNodeParent == null) {
            property = this.resolveProperty(this.persistentClass, propertyNode);
        } else {
            Optional<Value> parentValueOptional = this.addDirtyPathStringRepresentationsRecursively(pathsAsStrings, propertyNodeParent, false);
            if (!parentValueOptional.isPresent()) {
                return Optional.empty();
            }
            Value parentValue = parentValueOptional.get();
            if (!(parentValue instanceof Component)) {
                throw log.unknownPathForDirtyChecking(this.persistentClass.getMappedClass(), (PojoModelPath)propertyNode, null);
            }
            property = this.resolveProperty((Component)parentValue, propertyNode);
        }
        Value baseValue = property.getValue();
        ContainerValueExtractorPath extractorPath = path.getExtractorPath();
        if (extractorPath.isDefault()) {
            throw new AssertionFailure("Expected a non-default extractor path as per the " + PojoPathFilterFactory.class.getSimpleName() + " contract");
        }
        Class<?> valueClass = baseValue.getClass();
        if (Component.class.isAssignableFrom(valueClass)) {
            if (extractorPath.isEmpty()) {
                if (isWholePath) {
                    pathsAsStrings.add(path.getParent().toPropertyString());
                    return Optional.empty();
                }
                return Optional.of(baseValue);
            }
        } else {
            if (SimpleValue.class.equals(valueClass)) {
                pathsAsStrings.add(propertyNode.toPropertyString());
                return Optional.empty();
            }
            if (SimpleValue.class.isAssignableFrom(valueClass)) {
                if (isWholePath && ToOne.class.isAssignableFrom(valueClass) || isWholePath && Any.class.isAssignableFrom(valueClass)) {
                    pathsAsStrings.add(path.getParent().toPropertyString());
                    return Optional.empty();
                }
                return Optional.of(baseValue);
            }
            if (Collection.class.isAssignableFrom(valueClass)) {
                Collection collectionValue;
                if (extractorPath.isEmpty()) {
                    throw log.unknownPathForDirtyChecking(this.persistentClass.getMappedClass(), (PojoModelPath)propertyNode, null);
                }
                List extractorClasses = extractorPath.getExplicitExtractorClasses();
                Iterator extractorClassIterator = extractorClasses.iterator();
                Value containedValue = baseValue;
                do {
                    collectionValue = (Collection)containedValue;
                    try {
                        containedValue = this.resolveContainedValue(collectionValue, (Class)extractorClassIterator.next());
                    }
                    catch (SearchException e) {
                        throw log.unknownPathForDirtyChecking(this.persistentClass.getMappedClass(), (PojoModelPath)path, (Exception)((Object)e));
                    }
                } while (extractorClassIterator.hasNext() && containedValue instanceof Collection);
                if (!extractorClassIterator.hasNext()) {
                    Class<?> containedValueClass = containedValue.getClass();
                    if (SimpleValue.class.equals(containedValueClass) || Component.class.isAssignableFrom(containedValueClass) || isWholePath && OneToMany.class.isAssignableFrom(containedValueClass) || isWholePath && ToOne.class.isAssignableFrom(containedValueClass) || isWholePath && Any.class.isAssignableFrom(containedValueClass)) {
                        pathsAsStrings.add(propertyNode.toPropertyString());
                        pathsAsStrings.add(collectionValue.getRole());
                        return Optional.empty();
                    }
                    return Optional.of(containedValue);
                }
            }
        }
        throw log.unknownPathForDirtyChecking(this.persistentClass.getMappedClass(), (PojoModelPath)path, null);
    }

    private Value resolveContainedValue(Collection collectionValue, Class<? extends ContainerValueExtractor> extractorClass) {
        if (ArrayElementExtractor.class.equals(extractorClass)) {
            if (collectionValue instanceof Array) {
                return collectionValue.getElement();
            }
        } else if (MapValueExtractor.class.equals(extractorClass)) {
            if (collectionValue instanceof Map) {
                return collectionValue.getElement();
            }
        } else if (MapKeyExtractor.class.equals(extractorClass)) {
            if (collectionValue instanceof Map) {
                return ((Map)collectionValue).getIndex();
            }
        } else if (CollectionElementExtractor.class.equals(extractorClass)) {
            return collectionValue.getElement();
        }
        throw log.invalidContainerValueExtractorForDirtyChecking(collectionValue.getClass(), extractorClass);
    }

    private Property resolveProperty(PersistentClass persistentClass, PojoModelPathPropertyNode propertyNode) {
        try {
            return persistentClass.getProperty(propertyNode.getPropertyName());
        }
        catch (MappingException e) {
            throw log.unknownPathForDirtyChecking(persistentClass.getMappedClass(), (PojoModelPath)propertyNode, (Exception)((Object)e));
        }
    }

    private Property resolveProperty(Component parentValue, PojoModelPathPropertyNode propertyNode) {
        try {
            return parentValue.getProperty(propertyNode.getPropertyName());
        }
        catch (MappingException e) {
            throw log.unknownPathForDirtyChecking(this.persistentClass.getMappedClass(), (PojoModelPath)propertyNode, (Exception)((Object)e));
        }
    }
}

