/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.impl;

import java.util.List;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.query.SearchQueryResultContext;
import org.hibernate.search.mapper.orm.hibernate.FullTextQuery;
import org.hibernate.search.mapper.orm.hibernate.FullTextQueryResultDefinitionContext;
import org.hibernate.search.mapper.orm.impl.FullTextQueryImpl;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableObjectLoadingOptions;
import org.hibernate.search.mapper.orm.search.loading.impl.ObjectLoaderBuilder;
import org.hibernate.search.mapper.pojo.search.spi.PojoSearchTargetDelegate;

class FullTextQueryResultDefinitionContextImpl<O>
implements FullTextQueryResultDefinitionContext<O> {
    private final PojoSearchTargetDelegate<O, O> searchTargetDelegate;
    private final SessionImplementor sessionImplementor;
    private final ObjectLoaderBuilder<O> objectLoaderBuilder;

    FullTextQueryResultDefinitionContextImpl(PojoSearchTargetDelegate<O, O> searchTargetDelegate, SessionImplementor sessionImplementor) {
        this.searchTargetDelegate = searchTargetDelegate;
        this.sessionImplementor = sessionImplementor;
        this.objectLoaderBuilder = new ObjectLoaderBuilder((Session)sessionImplementor, searchTargetDelegate.getTargetedIndexedTypes());
    }

    @Override
    public SearchQueryResultContext<? extends FullTextQuery<O>> asEntity() {
        MutableObjectLoadingOptions loadingOptions = new MutableObjectLoadingOptions();
        return this.searchTargetDelegate.queryAsLoadedObject(this.objectLoaderBuilder.build(loadingOptions), q -> new FullTextQueryImpl(q, this.sessionImplementor, loadingOptions));
    }

    @Override
    public <T> SearchQueryResultContext<? extends FullTextQuery<T>> asProjection(SearchProjection<T> projection) {
        MutableObjectLoadingOptions loadingOptions = new MutableObjectLoadingOptions();
        return this.searchTargetDelegate.queryAsProjection(this.objectLoaderBuilder.build(loadingOptions), q -> new FullTextQueryImpl(q, this.sessionImplementor, loadingOptions), projection);
    }

    @Override
    public SearchQueryResultContext<? extends FullTextQuery<List<?>>> asProjections(SearchProjection<?> ... projections) {
        MutableObjectLoadingOptions loadingOptions = new MutableObjectLoadingOptions();
        return this.searchTargetDelegate.queryAsProjections(this.objectLoaderBuilder.build(loadingOptions), q -> new FullTextQueryImpl(q, this.sessionImplementor, loadingOptions), projections);
    }
}

