/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.search.loading.spi.ObjectLoader;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableObjectLoader;
import org.hibernate.search.mapper.pojo.search.PojoReference;
import org.hibernate.search.util.impl.common.LoggerFactory;

public class HibernateOrmByTypeObjectLoader<O, T>
implements ObjectLoader<PojoReference, T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<Class<? extends O>, HibernateOrmComposableObjectLoader<PojoReference, ? extends T>> delegatesByConcreteType;

    public HibernateOrmByTypeObjectLoader(Map<Class<? extends O>, HibernateOrmComposableObjectLoader<PojoReference, ? extends T>> delegatesByConcreteType) {
        this.delegatesByConcreteType = delegatesByConcreteType;
    }

    public List<T> load(List<PojoReference> references) {
        HibernateOrmComposableObjectLoader delegate;
        LinkedHashMap objectsByReference = new LinkedHashMap(references.size());
        HashMap<HibernateOrmComposableObjectLoader, List> referencesByDelegate = new HashMap<HibernateOrmComposableObjectLoader, List>();
        for (PojoReference pojoReference : references) {
            objectsByReference.put(pojoReference, null);
            delegate = this.getDelegate(pojoReference.getType());
            referencesByDelegate.computeIfAbsent(delegate, ignored -> new ArrayList()).add(pojoReference);
        }
        for (Map.Entry entry : referencesByDelegate.entrySet()) {
            delegate = (HibernateOrmComposableObjectLoader)entry.getKey();
            List referencesForDelegate = (List)entry.getValue();
            delegate.load(referencesForDelegate, objectsByReference);
        }
        ArrayList result = new ArrayList(references.size());
        for (Object value : objectsByReference.values()) {
            result.add(value);
        }
        return result;
    }

    private HibernateOrmComposableObjectLoader<PojoReference, ? extends T> getDelegate(Class<?> entityType) {
        HibernateOrmComposableObjectLoader<PojoReference, ? extends T> delegate = this.delegatesByConcreteType.get(entityType);
        if (delegate == null) {
            throw log.unexpectedSearchHitType(entityType, this.delegatesByConcreteType.keySet());
        }
        return delegate;
    }
}

