/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.Session;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableObjectLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableObjectLoadingOptions;
import org.hibernate.search.mapper.pojo.search.PojoReference;

class HibernateOrmSingleTypeByIdObjectLoader<O, T>
implements HibernateOrmComposableObjectLoader<PojoReference, T> {
    private final Session session;
    private final Class<O> entityType;
    private final MutableObjectLoadingOptions loadingOptions;
    private final Function<? super O, T> hitTransformer;
    private MultiIdentifierLoadAccess<O> multiAccess;

    public HibernateOrmSingleTypeByIdObjectLoader(Session session, Class<O> entityType, MutableObjectLoadingOptions loadingOptions, Function<? super O, T> hitTransformer) {
        this.session = session;
        this.entityType = entityType;
        this.loadingOptions = loadingOptions;
        this.hitTransformer = hitTransformer;
    }

    public List<T> load(List<PojoReference> references) {
        List<O> loadedObjects = this.loadEntities(references);
        return loadedObjects.stream().map(this.hitTransformer).collect(Collectors.toList());
    }

    @Override
    public void load(List<PojoReference> references, Map<? super PojoReference, ? super T> objectsByReference) {
        List<O> loadedObjects = this.loadEntities(references);
        Iterator<PojoReference> referencesIterator = references.iterator();
        Iterator<O> loadedObjectIterator = loadedObjects.iterator();
        while (referencesIterator.hasNext()) {
            PojoReference reference = referencesIterator.next();
            O loadedObject = loadedObjectIterator.next();
            if (loadedObject == null) continue;
            objectsByReference.put((PojoReference)reference, this.hitTransformer.apply(loadedObject));
        }
    }

    private List<O> loadEntities(List<PojoReference> references) {
        ArrayList<Serializable> ids = new ArrayList<Serializable>(references.size());
        for (PojoReference reference : references) {
            ids.add((Serializable)reference.getId());
        }
        return this.getMultiAccess().multiLoad(ids);
    }

    private MultiIdentifierLoadAccess<O> getMultiAccess() {
        if (this.multiAccess == null) {
            this.multiAccess = this.session.byMultipleIds(this.entityType);
        }
        this.multiAccess.withBatchSize(this.loadingOptions.getFetchSize());
        return this.multiAccess;
    }
}

