/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.util.Collection;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.mapper.orm.impl.HibernateSearchContextService;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.search.SearchScope;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.session.spi.SearchSessionImplementor;

public class LazyInitSearchSession
implements SearchSession {
    private final SessionImplementor sessionImplementor;
    private SearchSessionImplementor delegate;

    public LazyInitSearchSession(SessionImplementor sessionImplementor) {
        this.sessionImplementor = sessionImplementor;
    }

    @Override
    public EntityManager toEntityManager() {
        return this.getDelegate().toEntityManager();
    }

    @Override
    public Session toOrmSession() {
        return this.getDelegate().toOrmSession();
    }

    @Override
    public <T> SearchScope<T> scope(Collection<? extends Class<? extends T>> types) {
        return this.getDelegate().scope(types);
    }

    @Override
    public MassIndexer createIndexer(Class<?> ... types) {
        return this.getDelegate().createIndexer(types);
    }

    private SearchSessionImplementor getDelegate() {
        if (this.delegate == null) {
            HibernateSearchContextService contextService = (HibernateSearchContextService)this.sessionImplementor.getSessionFactory().getServiceRegistry().getService(HibernateSearchContextService.class);
            this.delegate = contextService.getSearchSession(this.sessionImplementor);
        }
        return this.delegate;
    }
}

