/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.Metadata;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.mapper.orm.cfg.spi.HibernateOrmMapperSpiSettings;
import org.hibernate.search.mapper.orm.cfg.spi.HibernateOrmPropertyHandleFactoryName;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmGenericContextHelper;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmRawTypeModel;
import org.hibernate.search.mapper.orm.util.impl.HibernateOrmXClassOrdering;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandleFactory;
import org.hibernate.search.mapper.pojo.util.spi.AnnotationHelper;
import org.hibernate.search.util.common.impl.ReflectionHelper;
import org.hibernate.search.util.common.impl.StreamHelper;

public class HibernateOrmBootstrapIntrospector
implements PojoBootstrapIntrospector {
    private static final ConfigurationProperty<HibernateOrmPropertyHandleFactoryName> PROPERTY_HANDLE_FACTORY = ConfigurationProperty.forKey((String)"property_handle_factory").as(HibernateOrmPropertyHandleFactoryName.class, HibernateOrmPropertyHandleFactoryName::of).withDefault((Object)HibernateOrmMapperSpiSettings.Defaults.PROPERTY_HANDLE_FACTORY).build();
    private final Map<Class<?>, HibernateOrmBasicTypeMetadata> typeMetadata;
    private final ReflectionManager reflectionManager;
    private final PropertyHandleFactory propertyHandleFactory;
    private final AnnotationHelper annotationHelper;
    private final HibernateOrmGenericContextHelper genericContextHelper;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<?> missingRawTypeDeclaringContext;
    private final Map<Class<?>, PojoRawTypeModel<?>> typeModelCache = new HashMap();

    public static HibernateOrmBootstrapIntrospector create(Metadata metadata, ReflectionManager ormReflectionManager, ConfigurationPropertySource propertySource) {
        PropertyHandleFactory propertyHandleFactory;
        Collection persistentClasses = metadata.getEntityBindings();
        HashMap typeMetadata = new HashMap();
        HibernateOrmBootstrapIntrospector.collectPersistentTypes(typeMetadata, metadata.getEntityBindings());
        for (PersistentClass persistentClass : persistentClasses) {
            HibernateOrmBootstrapIntrospector.collectEmbeddedTypesRecursively(typeMetadata, (Value)persistentClass.getIdentifier());
            HibernateOrmBootstrapIntrospector.collectEmbeddedTypesRecursively(typeMetadata, persistentClass.getPropertyIterator());
        }
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        AnnotationHelper annotationHelper = new AnnotationHelper(lookup);
        HibernateOrmPropertyHandleFactoryName propertyHandleFactoryName = (HibernateOrmPropertyHandleFactoryName)((Object)PROPERTY_HANDLE_FACTORY.get(propertySource));
        switch (propertyHandleFactoryName) {
            case JAVA_LANG_REFLECT: {
                propertyHandleFactory = PropertyHandleFactory.usingJavaLangReflect();
                break;
            }
            case METHOD_HANDLE: {
                propertyHandleFactory = PropertyHandleFactory.usingMethodHandle((MethodHandles.Lookup)lookup);
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected property handle factory name: " + (Object)((Object)propertyHandleFactoryName));
            }
        }
        return new HibernateOrmBootstrapIntrospector(typeMetadata, ormReflectionManager, annotationHelper, propertyHandleFactory);
    }

    private static void collectPersistentTypes(Map<Class<?>, HibernateOrmBasicTypeMetadata> collected, Collection<PersistentClass> persistentClasses) {
        for (PersistentClass persistentClass : persistentClasses) {
            collected.put(persistentClass.getMappedClass(), HibernateOrmBasicTypeMetadata.create(persistentClass));
        }
    }

    private static void collectEmbeddedTypesRecursively(Map<Class<?>, HibernateOrmBasicTypeMetadata> collected, Iterator<Property> propertyIterator) {
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.next();
            HibernateOrmBootstrapIntrospector.collectEmbeddedTypesRecursively(collected, property.getValue());
        }
    }

    private static void collectEmbeddedTypesRecursively(Map<Class<?>, HibernateOrmBasicTypeMetadata> collected, Value value) {
        if (value instanceof Component) {
            Component component = (Component)value;
            collected.computeIfAbsent(component.getComponentClass(), ignored -> HibernateOrmBasicTypeMetadata.create(component));
            HibernateOrmBootstrapIntrospector.collectEmbeddedTypesRecursively(collected, component.getPropertyIterator());
        } else if (value instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collection = (org.hibernate.mapping.Collection)value;
            HibernateOrmBootstrapIntrospector.collectEmbeddedTypesRecursively(collected, collection.getElement());
            if (collection instanceof IndexedCollection) {
                IndexedCollection indexedCollection = (IndexedCollection)collection;
                HibernateOrmBootstrapIntrospector.collectEmbeddedTypesRecursively(collected, indexedCollection.getIndex());
            }
        }
    }

    private HibernateOrmBootstrapIntrospector(Map<Class<?>, HibernateOrmBasicTypeMetadata> typeMetadata, ReflectionManager reflectionManager, AnnotationHelper annotationHelper, PropertyHandleFactory propertyHandleFactory) {
        this.typeMetadata = typeMetadata;
        this.reflectionManager = reflectionManager;
        this.propertyHandleFactory = propertyHandleFactory;
        this.annotationHelper = annotationHelper;
        this.genericContextHelper = new HibernateOrmGenericContextHelper(this);
        this.missingRawTypeDeclaringContext = new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, Object.class);
    }

    public <T> PojoRawTypeModel<T> getTypeModel(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            clazz = ReflectionHelper.getPrimitiveWrapperType(clazz);
        }
        return this.typeModelCache.computeIfAbsent(clazz, this::createTypeModel);
    }

    public <T> PojoGenericTypeModel<T> getGenericTypeModel(Class<T> clazz) {
        return this.missingRawTypeDeclaringContext.createGenericTypeModel(clazz);
    }

    <T> Stream<HibernateOrmRawTypeModel<? super T>> getAscendingSuperTypes(XClass xClass) {
        return HibernateOrmXClassOrdering.get().getAscendingSuperTypes(xClass).map(superType -> (HibernateOrmRawTypeModel)this.getTypeModel((XClass)superType));
    }

    <T> Stream<HibernateOrmRawTypeModel<? super T>> getDescendingSuperTypes(XClass xClass) {
        return HibernateOrmXClassOrdering.get().getDescendingSuperTypes(xClass).map(superType -> (HibernateOrmRawTypeModel)this.getTypeModel((XClass)superType));
    }

    XClass toXClass(Class<?> type) {
        return this.reflectionManager.toXClass(type);
    }

    Map<String, XProperty> getDeclaredFieldAccessXPropertiesByName(XClass xClass) {
        return xClass.getDeclaredProperties("field").stream().collect(this.xPropertiesByNameNoDuplicate());
    }

    Map<String, XProperty> getDeclaredMethodAccessXPropertiesByName(XClass xClass) {
        return xClass.getDeclaredProperties("property").stream().collect(this.xPropertiesByNameNoDuplicate());
    }

    <A extends Annotation> Optional<A> getAnnotationByType(XAnnotatedElement xAnnotated, Class<A> annotationType) {
        return Optional.ofNullable(xAnnotated.getAnnotation(annotationType));
    }

    <A extends Annotation> Stream<A> getAnnotationsByType(XAnnotatedElement xAnnotated, Class<A> annotationType) {
        return Arrays.stream(xAnnotated.getAnnotations()).flatMap(arg_0 -> ((AnnotationHelper)this.annotationHelper).expandRepeatableContainingAnnotation(arg_0)).filter(annotation -> annotationType.isAssignableFrom(annotation.annotationType())).map(annotationType::cast);
    }

    Stream<? extends Annotation> getAnnotationsByMetaAnnotationType(XAnnotatedElement xAnnotated, Class<? extends Annotation> metaAnnotationType) {
        return Arrays.stream(xAnnotated.getAnnotations()).flatMap(arg_0 -> ((AnnotationHelper)this.annotationHelper).expandRepeatableContainingAnnotation(arg_0)).filter(annotation -> this.annotationHelper.isMetaAnnotated(annotation, metaAnnotationType));
    }

    PropertyHandle<?> createPropertyHandle(String name, Member member) throws IllegalAccessException {
        if (member instanceof Method) {
            Method method = (Method)member;
            HibernateOrmBootstrapIntrospector.setAccessible(method);
            return this.propertyHandleFactory.createForMethod(name, method);
        }
        if (member instanceof Field) {
            Field field = (Field)member;
            HibernateOrmBootstrapIntrospector.setAccessible(field);
            return this.propertyHandleFactory.createForField(name, field);
        }
        throw new AssertionFailure("Unexpected type for a " + Member.class.getName() + ": " + member);
    }

    private PojoTypeModel<?> getTypeModel(XClass xClass) {
        return this.getTypeModel(this.reflectionManager.toClass(xClass));
    }

    private <T> PojoRawTypeModel<T> createTypeModel(Class<T> type) {
        return new HibernateOrmRawTypeModel<T>(this, type, this.typeMetadata.get(type), new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, type));
    }

    private Collector<XProperty, ?, Map<String, XProperty>> xPropertiesByNameNoDuplicate() {
        return StreamHelper.toMap(XMember::getName, Function.identity(), TreeMap::new);
    }

    private static void setAccessible(AccessibleObject member) {
        block2: {
            try {
                member.setAccessible(true);
            }
            catch (SecurityException se) {
                if (Modifier.isPublic(((Member)((Object)member)).getModifiers())) break block2;
                throw se;
            }
        }
    }
}

