/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultClassAndResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;

final class HibernateOrmClassLoaderServiceClassAndResourceResolver
implements ClassResolver,
ResourceResolver {
    private final ClassLoaderService hibernateClassLoaderService;
    private final DefaultClassAndResourceResolver internalClassResolver;

    HibernateOrmClassLoaderServiceClassAndResourceResolver(ClassLoaderService hibernateClassLoaderService) {
        this.hibernateClassLoaderService = hibernateClassLoaderService;
        this.internalClassResolver = new DefaultClassAndResourceResolver();
    }

    public <T> Class<T> classForName(String className) {
        try {
            return this.hibernateClassLoaderService.classForName(className);
        }
        catch (LinkageError | ClassLoadingException e) {
            return this.internalClassResolver.classForName(className);
        }
    }

    public URL locateResource(String name) {
        URL url = this.hibernateClassLoaderService.locateResource(name);
        if (url == null) {
            url = this.internalClassResolver.locateResource(name);
        }
        return url;
    }

    public InputStream locateResourceStream(String name) {
        InputStream in = this.hibernateClassLoaderService.locateResourceStream(name);
        if (in == null) {
            in = this.internalClassResolver.locateResourceStream(name);
        }
        return in;
    }

    public <T> Iterable<T> loadJavaServices(Class<T> serviceContract) {
        Collection servicesFromORMCLassLoader = this.hibernateClassLoaderService.loadJavaServices(serviceContract);
        Set servicesFromLocalClassLoader = this.internalClassResolver.loadJavaServices(serviceContract);
        LinkedHashMap combined = new LinkedHashMap();
        this.addAllServices(servicesFromORMCLassLoader, combined);
        this.addAllServices(servicesFromLocalClassLoader, combined);
        return combined.values();
    }

    private <T> void addAllServices(Iterable<T> services, Map<String, T> combined) {
        for (T service : services) {
            combined.put(service.getClass().getName(), service);
        }
    }
}

