/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.AbstractCollectionEvent;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.event.impl.EventsHibernateSearchState;
import org.hibernate.search.mapper.orm.event.impl.InitializingHibernateSearchState;
import org.hibernate.search.mapper.orm.event.impl.OptimalEventsHibernateSearchState;
import org.hibernate.search.mapper.orm.impl.HibernateSearchContextService;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class HibernateSearchEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener,
FlushEventListener {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final boolean dirtyCheckingEnabled;
    private volatile EventsHibernateSearchState state;

    public HibernateSearchEventListener(CompletableFuture<HibernateSearchContextService> contextFuture, boolean dirtyCheckingEnabled) {
        this.state = new InitializingHibernateSearchState((CompletableFuture<HibernateSearchContextService>)contextFuture.thenApply(this::doInitialize));
        this.dirtyCheckingEnabled = dirtyCheckingEnabled;
    }

    public void onPostDelete(PostDeleteEvent event) {
        Object entity;
        HibernateSearchContextService context = this.state.getHibernateSearchContext();
        if (this.isWorkable(context, entity = event.getEntity())) {
            context.getCurrentWorkPlan((SessionImplementor)event.getSession()).delete((Object)event.getId(), entity);
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        Object entity;
        HibernateSearchContextService context = this.state.getHibernateSearchContext();
        if (this.isWorkable(context, entity = event.getEntity())) {
            context.getCurrentWorkPlan((SessionImplementor)event.getSession()).add((Object)event.getId(), entity);
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object entity;
        HibernateSearchContextService context = this.state.getHibernateSearchContext();
        if (this.isWorkable(context, entity = event.getEntity())) {
            PojoWorkPlan workPlan = context.getCurrentWorkPlan((SessionImplementor)event.getSession());
            if (this.dirtyCheckingEnabled) {
                workPlan.update((Object)event.getId(), entity, this.getDirtyPropertyNames(event));
            } else {
                workPlan.update((Object)event.getId(), entity);
            }
        }
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onFlush(FlushEvent event) {
    }

    private HibernateSearchContextService doInitialize(HibernateSearchContextService context) {
        log.debug("Hibernate Search dirty checks " + (this.dirtyCheckingEnabled ? "enabled" : "disabled"));
        this.state = new OptimalEventsHibernateSearchState(context);
        return context;
    }

    private boolean isWorkable(HibernateSearchContextService context, Object entity) {
        return context.getMapping().isWorkable(entity);
    }

    private void processCollectionEvent(AbstractCollectionEvent event) {
        HibernateSearchContextService context = this.state.getHibernateSearchContext();
        Object entity = event.getAffectedOwnerOrNull();
        if (entity == null) {
            return;
        }
        if (this.isWorkable(context, entity)) {
            PojoWorkPlan workPlan = context.getCurrentWorkPlan((SessionImplementor)event.getSession());
            if (this.dirtyCheckingEnabled) {
                PersistentCollection persistentCollection = event.getCollection();
                String collectionRole = null;
                if (persistentCollection != null) {
                    collectionRole = persistentCollection.getRole();
                }
                if (collectionRole != null) {
                    workPlan.update((Object)event.getAffectedOwnerIdOrNull(), entity, new String[]{collectionRole});
                } else {
                    workPlan.update((Object)event.getAffectedOwnerIdOrNull(), entity);
                }
            } else {
                workPlan.update((Object)event.getAffectedOwnerIdOrNull(), entity);
            }
        }
    }

    public String[] getDirtyPropertyNames(PostUpdateEvent event) {
        EntityPersister persister = event.getPersister();
        int[] dirtyProperties = event.getDirtyProperties();
        if (dirtyProperties != null && dirtyProperties.length > 0) {
            String[] propertyNames = persister.getPropertyNames();
            int length = dirtyProperties.length;
            String[] dirtyPropertyNames = new String[length];
            for (int i = 0; i < length; ++i) {
                dirtyPropertyNames[i] = propertyNames[dirtyProperties[i]];
            }
            return dirtyPropertyNames;
        }
        return EMPTY_STRING_ARRAY;
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }
}

