/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import org.hibernate.Hibernate;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;

public class HibernateOrmRuntimeIntrospector
implements PojoRuntimeIntrospector {
    private final SessionImplementor sessionImplementor;

    public HibernateOrmRuntimeIntrospector(SessionImplementor sessionImplementor) {
        this.sessionImplementor = sessionImplementor;
    }

    public <T> Class<? extends T> getClass(T entity) {
        return Hibernate.getClass(entity);
    }

    public Object unproxy(Object value) {
        if (value instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer lazyInitializer = proxy.getHibernateLazyInitializer();
            Object initialized = lazyInitializer.getImplementation((SharedSessionContractImplementor)this.sessionImplementor);
            if (initialized != null) {
                return initialized;
            }
            return this.sessionImplementor.getPersistenceContext().unproxyAndReassociate((Object)proxy);
        }
        return value;
    }
}

