/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.impl;

import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortContainerContext;
import org.hibernate.search.mapper.orm.search.SearchScope;
import org.hibernate.search.mapper.orm.search.dsl.query.HibernateOrmSearchQueryResultDefinitionContext;
import org.hibernate.search.mapper.orm.search.dsl.query.impl.HibernateOrmSearchQueryResultDefinitionContextImpl;
import org.hibernate.search.mapper.orm.search.loading.context.impl.HibernateOrmLoadingContext;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderBuilder;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.pojo.search.PojoReference;
import org.hibernate.search.mapper.pojo.search.spi.PojoSearchScopeDelegate;

public class SearchScopeImpl<E>
implements SearchScope<E> {
    private final PojoSearchScopeDelegate<E, E> delegate;
    private final SessionImplementor sessionImplementor;

    public SearchScopeImpl(PojoSearchScopeDelegate<E, E> delegate, SessionImplementor sessionImplementor) {
        this.delegate = delegate;
        this.sessionImplementor = sessionImplementor;
    }

    @Override
    public HibernateOrmSearchQueryResultDefinitionContext<E> search() {
        EntityLoaderBuilder entityLoaderBuilder = new EntityLoaderBuilder((Session)this.sessionImplementor, this.delegate.getIncludedIndexedTypes());
        MutableEntityLoadingOptions loadingOptions = new MutableEntityLoadingOptions();
        HibernateOrmLoadingContext.Builder loadingContextBuilder = new HibernateOrmLoadingContext.Builder(this.sessionImplementor, this.delegate, entityLoaderBuilder, loadingOptions);
        return new HibernateOrmSearchQueryResultDefinitionContextImpl(this.delegate.search(loadingContextBuilder), loadingOptions);
    }

    @Override
    public SearchPredicateFactoryContext predicate() {
        return this.delegate.predicate();
    }

    @Override
    public SearchSortContainerContext sort() {
        return this.delegate.sort();
    }

    @Override
    public SearchProjectionFactoryContext<PojoReference, E> projection() {
        return this.delegate.projection();
    }
}

