/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.util.HashMap;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmByTypeEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmSingleTypeByIdEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.pojo.search.PojoReference;

public class EntityLoaderBuilder<E> {
    private final Session session;
    private final Set<Class<? extends E>> concreteIndexedClasses;

    public EntityLoaderBuilder(Session session, Set<Class<? extends E>> concreteIndexedClasses) {
        this.session = session;
        this.concreteIndexedClasses = concreteIndexedClasses;
    }

    public EntityLoader<PojoReference, E> build(MutableEntityLoadingOptions mutableLoadingOptions) {
        if (this.concreteIndexedClasses.size() == 1) {
            Class<? extends E> concreteIndexedType = this.concreteIndexedClasses.iterator().next();
            return this.buildForSingleType(mutableLoadingOptions, concreteIndexedType);
        }
        return this.buildForMultipleTypes(mutableLoadingOptions);
    }

    private HibernateOrmComposableEntityLoader<PojoReference, E> buildForSingleType(MutableEntityLoadingOptions mutableLoadingOptions, Class<? extends E> concreteIndexedType) {
        return new HibernateOrmSingleTypeByIdEntityLoader<E>(this.session, concreteIndexedType, mutableLoadingOptions);
    }

    private EntityLoader<PojoReference, E> buildForMultipleTypes(MutableEntityLoadingOptions mutableLoadingOptions) {
        HashMap delegateByConcreteType = new HashMap(this.concreteIndexedClasses.size());
        for (Class<? extends E> clazz : this.concreteIndexedClasses) {
            HibernateOrmComposableEntityLoader<PojoReference, ? extends E> delegate = this.buildForSingleType(mutableLoadingOptions, clazz);
            delegateByConcreteType.put(clazz, delegate);
        }
        return new HibernateOrmByTypeEntityLoader(delegateByConcreteType);
    }
}

