/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.pojo.search.PojoReference;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmByTypeEntityLoader<E, T>
implements EntityLoader<PojoReference, T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<Class<? extends E>, HibernateOrmComposableEntityLoader<PojoReference, ? extends T>> delegatesByConcreteType;

    public HibernateOrmByTypeEntityLoader(Map<Class<? extends E>, HibernateOrmComposableEntityLoader<PojoReference, ? extends T>> delegatesByConcreteType) {
        this.delegatesByConcreteType = delegatesByConcreteType;
    }

    public List<T> loadBlocking(List<PojoReference> references) {
        HibernateOrmComposableEntityLoader delegate;
        LinkedHashMap objectsByReference = new LinkedHashMap(references.size());
        HashMap<HibernateOrmComposableEntityLoader, List> referencesByDelegate = new HashMap<HibernateOrmComposableEntityLoader, List>();
        for (PojoReference pojoReference : references) {
            objectsByReference.put(pojoReference, null);
            delegate = this.getDelegate(pojoReference.getType());
            referencesByDelegate.computeIfAbsent(delegate, ignored -> new ArrayList()).add(pojoReference);
        }
        for (Map.Entry entry : referencesByDelegate.entrySet()) {
            delegate = (HibernateOrmComposableEntityLoader)entry.getKey();
            List referencesForDelegate = (List)entry.getValue();
            delegate.loadBlocking(referencesForDelegate, objectsByReference);
        }
        ArrayList result = new ArrayList(references.size());
        for (Object value : objectsByReference.values()) {
            result.add(value);
        }
        return result;
    }

    private HibernateOrmComposableEntityLoader<PojoReference, ? extends T> getDelegate(Class<?> entityType) {
        HibernateOrmComposableEntityLoader<PojoReference, ? extends T> delegate = this.delegatesByConcreteType.get(entityType);
        if (delegate == null) {
            throw log.unexpectedSearchHitType(entityType, this.delegatesByConcreteType.keySet());
        }
        return delegate;
    }
}

