/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.Session;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.pojo.search.PojoReference;

class HibernateOrmSingleTypeByIdEntityLoader<E>
implements HibernateOrmComposableEntityLoader<PojoReference, E> {
    private final Session session;
    private final Class<? extends E> entityType;
    private final MutableEntityLoadingOptions loadingOptions;
    private MultiIdentifierLoadAccess<? extends E> multiAccess;

    public HibernateOrmSingleTypeByIdEntityLoader(Session session, Class<? extends E> entityType, MutableEntityLoadingOptions loadingOptions) {
        this.session = session;
        this.entityType = entityType;
        this.loadingOptions = loadingOptions;
    }

    public List<? extends E> loadBlocking(List<PojoReference> references) {
        return this.loadEntities(references);
    }

    @Override
    public void loadBlocking(List<PojoReference> references, Map<? super PojoReference, ? super E> objectsByReference) {
        List<E> loadedObjects = this.loadEntities(references);
        Iterator<PojoReference> referencesIterator = references.iterator();
        Iterator<E> loadedObjectIterator = loadedObjects.iterator();
        while (referencesIterator.hasNext()) {
            PojoReference reference = referencesIterator.next();
            E loadedObject = loadedObjectIterator.next();
            if (loadedObject == null) continue;
            objectsByReference.put((PojoReference)reference, loadedObject);
        }
    }

    private List<? extends E> loadEntities(List<PojoReference> references) {
        ArrayList<Serializable> ids = new ArrayList<Serializable>(references.size());
        for (PojoReference reference : references) {
            ids.add((Serializable)reference.getId());
        }
        return this.getMultiAccess().multiLoad(ids);
    }

    private MultiIdentifierLoadAccess<? extends E> getMultiAccess() {
        if (this.multiAccess == null) {
            this.multiAccess = this.session.byMultipleIds(this.entityType);
        }
        this.multiAccess.withBatchSize(this.loadingOptions.getFetchSize());
        return this.multiAccess;
    }
}

