/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.backend.index.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.index.DocumentRefreshStrategy;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.context.impl.HibernateOrmMappingContextImpl;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexerImpl;
import org.hibernate.search.mapper.orm.search.SearchScope;
import org.hibernate.search.mapper.orm.search.impl.SearchScopeImpl;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.session.context.impl.HibernateOrmSessionContextImpl;
import org.hibernate.search.mapper.orm.session.spi.SearchSessionBuilder;
import org.hibernate.search.mapper.orm.session.spi.SearchSessionImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.search.spi.PojoSearchScopeDelegate;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.session.spi.AbstractPojoSearchSession;
import org.hibernate.search.mapper.pojo.work.spi.PojoSessionWorkExecutor;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmSearchSession
extends AbstractPojoSearchSession
implements SearchSessionImplementor,
SearchSession {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SessionImplementor sessionImplementor;
    private AutomaticIndexingSynchronizationStrategy synchronizationStrategy;

    private HibernateOrmSearchSession(HibernateOrmSearchSessionBuilder builder) {
        super((AbstractPojoSearchSession.AbstractBuilder)builder);
        this.sessionImplementor = builder.sessionImplementor;
        this.synchronizationStrategy = builder.synchronizationStrategy;
    }

    @Override
    public void close() {
    }

    @Override
    public EntityManager toEntityManager() {
        return this.sessionImplementor;
    }

    @Override
    public Session toOrmSession() {
        return this.sessionImplementor;
    }

    @Override
    public <T> SearchScope<T> scope(Collection<? extends Class<? extends T>> types) {
        this.checkOrmSessionIsOpen();
        PojoSearchScopeDelegate searchScopeDelegate = this.getDelegate().createPojoSearchScope(types);
        return new SearchScopeImpl(searchScopeDelegate, this.sessionImplementor);
    }

    @Override
    public MassIndexer createIndexer(Class<?> ... types) {
        this.checkOrmSessionIsOpen();
        if (types.length == 0) {
            types = new Class[]{Object.class};
        }
        return new MassIndexerImpl(this.sessionImplementor.getFactory(), this.sessionImplementor.getTenantIdentifier(), types);
    }

    @Override
    public PojoWorkPlan createWorkPlan(DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.getDelegate().createWorkPlan(commitStrategy, refreshStrategy);
    }

    @Override
    public PojoSessionWorkExecutor createSessionWorkExecutor(DocumentCommitStrategy commitStrategy) {
        return this.getDelegate().createSessionWorkExecutor(commitStrategy);
    }

    @Override
    public void setAutomaticIndexingSynchronizationStrategy(AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        this.synchronizationStrategy = synchronizationStrategy;
    }

    @Override
    public AutomaticIndexingSynchronizationStrategy getAutomaticIndexingSynchronizationStrategy() {
        return this.synchronizationStrategy;
    }

    private void checkOrmSessionIsOpen() {
        try {
            this.sessionImplementor.checkOpen();
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionIsClosed(e);
        }
    }

    public static class HibernateOrmSearchSessionBuilder
    extends AbstractPojoSearchSession.AbstractBuilder<HibernateOrmSearchSession>
    implements SearchSessionBuilder {
        private final HibernateOrmMappingContextImpl mappingContext;
        private final SessionImplementor sessionImplementor;
        private final AutomaticIndexingSynchronizationStrategy synchronizationStrategy;

        public HibernateOrmSearchSessionBuilder(PojoMappingDelegate mappingDelegate, HibernateOrmMappingContextImpl mappingContext, SessionImplementor sessionImplementor, AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
            super(mappingDelegate);
            this.mappingContext = mappingContext;
            this.sessionImplementor = sessionImplementor;
            this.synchronizationStrategy = synchronizationStrategy;
        }

        protected AbstractPojoSessionContextImplementor buildSessionContext() {
            return new HibernateOrmSessionContextImpl(this.mappingContext, this.sessionImplementor);
        }

        @Override
        public HibernateOrmSearchSession build() {
            return new HibernateOrmSearchSession(this);
        }
    }
}

