/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmIntegrationBooterImpl;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchSessionFactoryObserver;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmAutomaticIndexingStrategyName;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmMapperSettings;
import org.hibernate.search.mapper.orm.cfg.impl.HibernateOrmConfigurationPropertySource;
import org.hibernate.search.mapper.orm.event.impl.HibernateSearchEventListener;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateSearchContextService;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class HibernateSearchIntegrator
implements Integrator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Boolean> AUTOREGISTER_LISTENERS = ConfigurationProperty.forKey((String)"autoregister_listeners").asBoolean().withDefault((Object)true).build();
    private static final ConfigurationProperty<HibernateOrmAutomaticIndexingStrategyName> AUTOMATIC_INDEXING_STRATEGY = ConfigurationProperty.forKey((String)"automatic_indexing.strategy").as(HibernateOrmAutomaticIndexingStrategyName.class, HibernateOrmAutomaticIndexingStrategyName::of).withDefault((Object)HibernateOrmMapperSettings.Defaults.AUTOMATIC_INDEXING_STRATEGY).build();
    private static final ConfigurationProperty<Boolean> DIRTY_CHECK_ENABLED = ConfigurationProperty.forKey((String)"automatic_indexing.enable_dirty_check").asBoolean().withDefault((Object)true).build();

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        ConfigurationService configurationService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        HibernateOrmConfigurationPropertySource propertySource = new HibernateOrmConfigurationPropertySource(configurationService);
        if (!((Boolean)AUTOREGISTER_LISTENERS.get((ConfigurationPropertySource)propertySource)).booleanValue()) {
            log.debug("Skipping Hibernate Search event listener auto registration");
            return;
        }
        BootstrapContext bootstrapContext = ((MetadataImplementor)metadata).getTypeConfiguration().getMetadataBuildingContext().getBootstrapContext();
        HibernateOrmIntegrationBooterImpl booter = new HibernateOrmIntegrationBooterImpl(metadata, bootstrapContext);
        CompletableFuture<SessionFactoryImplementor> sessionFactoryCreatedFuture = new CompletableFuture<SessionFactoryImplementor>();
        CompletableFuture sessionFactoryClosingFuture = new CompletableFuture();
        CompletableFuture<HibernateSearchContextService> contextFuture = booter.orchestrateBootAndShutdown(sessionFactoryCreatedFuture, sessionFactoryClosingFuture);
        HibernateSearchSessionFactoryObserver observer = new HibernateSearchSessionFactoryObserver(sessionFactoryCreatedFuture, sessionFactoryClosingFuture, contextFuture);
        sessionFactory.addObserver((SessionFactoryObserver)observer);
        HibernateOrmAutomaticIndexingStrategyName automaticIndexingStrategyName = (HibernateOrmAutomaticIndexingStrategyName)((Object)AUTOMATIC_INDEXING_STRATEGY.get((ConfigurationPropertySource)propertySource));
        if (HibernateOrmAutomaticIndexingStrategyName.SESSION.equals((Object)automaticIndexingStrategyName)) {
            log.debug("Hibernate Search event listeners activated");
            HibernateSearchEventListener hibernateSearchEventListener = new HibernateSearchEventListener(contextFuture, (Boolean)DIRTY_CHECK_ENABLED.get((ConfigurationPropertySource)propertySource));
            this.registerHibernateSearchEventListener(hibernateSearchEventListener, serviceRegistry);
        } else {
            log.debug("Hibernate Search event listeners deactivated");
        }
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private void registerHibernateSearchEventListener(HibernateSearchEventListener eventListener, SessionFactoryServiceRegistry serviceRegistry) {
        EventListenerRegistry listenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy((DuplicationStrategy)new KeepIfSameClassDuplicationStrategy(HibernateSearchEventListener.class));
        listenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_RECREATE, (Object[])new PostCollectionRecreateEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_REMOVE, (Object[])new PostCollectionRemoveEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_UPDATE, (Object[])new PostCollectionUpdateEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.FLUSH, (Object[])new FlushEventListener[]{eventListener});
    }

    public static class KeepIfSameClassDuplicationStrategy
    implements DuplicationStrategy {
        private final Class<?> checkClass;

        public KeepIfSameClassDuplicationStrategy(Class<?> checkClass) {
            this.checkClass = checkClass;
        }

        public boolean areMatch(Object listener, Object original) {
            return this.checkClass == original.getClass() && this.checkClass == listener.getClass();
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    }
}

