/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.lang.invoke.MethodHandles;
import javax.persistence.EntityManager;
import org.hibernate.BaseSessionEventListener;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.context.impl.HibernateOrmMappingContextImpl;
import org.hibernate.search.mapper.orm.mapping.impl.AbstractHibernateOrmTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmTypeContextContainer;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeMappingContext;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.work.spi.PojoSessionWorkExecutor;
import org.hibernate.search.util.common.impl.TransientReference;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmMapping
extends AbstractPojoMappingImplementor<HibernateOrmMapping>
implements HibernateOrmScopeMappingContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String SEARCH_SESSION_KEY = HibernateOrmMapping.class.getName() + "#SEARCH_SESSION_KEY";
    private final HibernateOrmMappingContextImpl mappingContext;
    private final HibernateOrmTypeContextContainer typeContextContainer;
    private final AutomaticIndexingSynchronizationStrategy synchronizationStrategy;

    HibernateOrmMapping(PojoMappingDelegate mappingDelegate, HibernateOrmTypeContextContainer typeContextContainer, SessionFactoryImplementor sessionFactoryImplementor, AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        super(mappingDelegate);
        this.typeContextContainer = typeContextContainer;
        this.mappingContext = new HibernateOrmMappingContextImpl(sessionFactoryImplementor);
        this.synchronizationStrategy = synchronizationStrategy;
    }

    public HibernateOrmMapping toConcreteType() {
        return this;
    }

    @Override
    public PojoSessionWorkExecutor createSessionWorkExecutor(SessionImplementor sessionImplementor, DocumentCommitStrategy commitStrategy) {
        return this.getSearchSession(sessionImplementor).createSessionWorkExecutor(commitStrategy);
    }

    HibernateOrmSearchSession getSearchSession(SessionImplementor sessionImplementor) {
        HibernateOrmSearchSession searchSession;
        TransientReference reference = (TransientReference)sessionImplementor.getProperties().get(SEARCH_SESSION_KEY);
        HibernateOrmSearchSession hibernateOrmSearchSession = searchSession = reference == null ? null : (HibernateOrmSearchSession)reference.get();
        if (searchSession == null) {
            searchSession = this.createSessionBuilder((EntityManager)sessionImplementor).build();
            reference = new TransientReference((Object)searchSession);
            sessionImplementor.setProperty(SEARCH_SESSION_KEY, (Object)reference);
            sessionImplementor.getEventListenerManager().addListener(new SessionEventListener[]{new SearchSessionClosingListener(sessionImplementor)});
        }
        return searchSession;
    }

    <E> AbstractHibernateOrmTypeContext<E> getTypeContext(Class<E> type) {
        return this.typeContextContainer.getByExactClass((Class)type);
    }

    private HibernateOrmSearchSession.HibernateOrmSearchSessionBuilder createSessionBuilder(EntityManager entityManager) {
        SessionImplementor sessionImplementor;
        try {
            sessionImplementor = (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionAccessError(e);
        }
        SessionFactory expectedSessionFactory = this.mappingContext.getSessionFactory();
        SessionFactoryImplementor givenSessionFactory = sessionImplementor.getSessionFactory();
        if (!givenSessionFactory.equals(expectedSessionFactory)) {
            throw log.usingDifferentSessionFactories(expectedSessionFactory, (SessionFactory)givenSessionFactory);
        }
        return new HibernateOrmSearchSession.HibernateOrmSearchSessionBuilder(this.getDelegate(), this.mappingContext, this, this.typeContextContainer, sessionImplementor, this.synchronizationStrategy);
    }

    private static class SearchSessionClosingListener
    extends BaseSessionEventListener {
        private final SessionImplementor sessionImplementor;

        private SearchSessionClosingListener(SessionImplementor sessionImplementor) {
            this.sessionImplementor = sessionImplementor;
        }

        public void end() {
            HibernateOrmSearchSession searchSession;
            TransientReference reference = (TransientReference)this.sessionImplementor.getProperties().get(SEARCH_SESSION_KEY);
            HibernateOrmSearchSession hibernateOrmSearchSession = searchSession = reference == null ? null : (HibernateOrmSearchSession)reference.get();
            if (searchSession != null) {
                searchSession.close();
            }
        }
    }
}

