/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.mapper.mapping.spi.MappingPartialBuildState;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmAutomaticIndexingSynchronizationStrategyName;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmMapperSettings;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmTypeContextContainer;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.util.common.AssertionFailure;

public class HibernateOrmMappingPartialBuildState
implements MappingPartialBuildState {
    private static final ConfigurationProperty<HibernateOrmAutomaticIndexingSynchronizationStrategyName> AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY = ConfigurationProperty.forKey((String)"automatic_indexing.synchronization_strategy").as(HibernateOrmAutomaticIndexingSynchronizationStrategyName.class, HibernateOrmAutomaticIndexingSynchronizationStrategyName::of).withDefault((Object)HibernateOrmMapperSettings.Defaults.AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY).build();
    private final PojoMappingDelegate mappingDelegate;
    private final HibernateOrmTypeContextContainer.Builder typeContextContainerBuilder;

    HibernateOrmMappingPartialBuildState(PojoMappingDelegate mappingDelegate, HibernateOrmTypeContextContainer.Builder typeContextContainerBuilder) {
        this.mappingDelegate = mappingDelegate;
        this.typeContextContainerBuilder = typeContextContainerBuilder;
    }

    public MappingImplementor<HibernateOrmMapping> bindToSessionFactory(SessionFactoryImplementor sessionFactoryImplementor, ConfigurationPropertySource propertySource) {
        AutomaticIndexingSynchronizationStrategy synchronizationStrategy = this.getAutomaticIndexingSynchronizationStrategy(propertySource);
        return new HibernateOrmMapping(this.mappingDelegate, this.typeContextContainerBuilder.build((SessionFactory)sessionFactoryImplementor), sessionFactoryImplementor, synchronizationStrategy);
    }

    public void closeOnFailure() {
        this.mappingDelegate.close();
    }

    private AutomaticIndexingSynchronizationStrategy getAutomaticIndexingSynchronizationStrategy(ConfigurationPropertySource propertySource) {
        HibernateOrmAutomaticIndexingSynchronizationStrategyName name = (HibernateOrmAutomaticIndexingSynchronizationStrategyName)((Object)AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY.get(propertySource));
        switch (name) {
            case QUEUED: {
                return AutomaticIndexingSynchronizationStrategy.queued();
            }
            case COMMITTED: {
                return AutomaticIndexingSynchronizationStrategy.committed();
            }
            case SEARCHABLE: {
                return AutomaticIndexingSynchronizationStrategy.searchable();
            }
        }
        throw new AssertionFailure("Unexpected automatic indexing synchronization strategy name: " + (Object)((Object)name));
    }
}

