/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.search.mapper.orm.mapping.impl.AbstractHibernateOrmTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmContainedTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmIndexedTypeContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeTypeContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionIndexedTypeContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContextProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

class HibernateOrmTypeContextContainer
implements HibernateOrmSessionTypeContextProvider {
    private final Map<Class<?>, HibernateOrmIndexedTypeContext<?>> indexedTypeContexts = new LinkedHashMap();
    private final Map<String, HibernateOrmIndexedTypeContext<?>> indexedTypeContextsByIndexName = new LinkedHashMap();
    private final Map<Class<?>, HibernateOrmContainedTypeContext<?>> containedTypeContexts = new LinkedHashMap();

    private HibernateOrmTypeContextContainer(Builder builder, SessionFactory sessionFactory) {
        for (Object contextBuilder : builder.indexedTypeContextBuilders) {
            HibernateOrmIndexedTypeContext indexedTypeContext = ((HibernateOrmIndexedTypeContext.Builder)contextBuilder).build(sessionFactory);
            this.indexedTypeContexts.put(indexedTypeContext.getJavaClass(), indexedTypeContext);
            this.indexedTypeContextsByIndexName.put(indexedTypeContext.getIndexName(), indexedTypeContext);
        }
        for (Object contextBuilder : builder.containedTypeContextBuilders) {
            HibernateOrmContainedTypeContext containedTypeContext = ((HibernateOrmContainedTypeContext.Builder)contextBuilder).build();
            this.containedTypeContexts.put(containedTypeContext.getJavaClass(), containedTypeContext);
        }
    }

    public <E> HibernateOrmIndexedTypeContext<E> getIndexedByExactClass(Class<E> clazz) {
        return this.indexedTypeContexts.get(clazz);
    }

    @Override
    public HibernateOrmSessionIndexedTypeContext getByIndexName(String indexName) {
        return this.indexedTypeContextsByIndexName.get(indexName);
    }

    public <E> HibernateOrmContainedTypeContext<E> getContainedByExactClass(Class<E> clazz) {
        return this.containedTypeContexts.get(clazz);
    }

    public <E> AbstractHibernateOrmTypeContext<E> getByExactClass(Class<E> clazz) {
        HibernateOrmScopeTypeContext result = this.getIndexedByExactClass((Class)clazz);
        if (result != null) {
            return result;
        }
        result = this.getContainedByExactClass((Class)clazz);
        return result;
    }

    static class Builder {
        private final List<HibernateOrmIndexedTypeContext.Builder<?>> indexedTypeContextBuilders = new ArrayList();
        private final List<HibernateOrmContainedTypeContext.Builder<?>> containedTypeContextBuilders = new ArrayList();

        Builder() {
        }

        <E> HibernateOrmIndexedTypeContext.Builder<E> addIndexed(PojoRawTypeModel<E> typeModel, String indexName) {
            HibernateOrmIndexedTypeContext.Builder builder = new HibernateOrmIndexedTypeContext.Builder(typeModel.getJavaClass(), indexName);
            this.indexedTypeContextBuilders.add(builder);
            return builder;
        }

        <E> HibernateOrmContainedTypeContext.Builder<E> addContained(PojoRawTypeModel<E> typeModel) {
            HibernateOrmContainedTypeContext.Builder builder = new HibernateOrmContainedTypeContext.Builder(typeModel.getJavaClass());
            this.containedTypeContextBuilders.add(builder);
            return builder;
        }

        HibernateOrmTypeContextContainer build(SessionFactory sessionFactory) {
            return new HibernateOrmTypeContextContainer(this, sessionFactory);
        }
    }
}

