/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.scope.impl;

import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryContext;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexerImpl;
import org.hibernate.search.mapper.orm.scope.SearchScope;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeIndexedTypeContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeMappingContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeSessionContext;
import org.hibernate.search.mapper.orm.search.dsl.query.HibernateOrmSearchQueryResultDefinitionContext;
import org.hibernate.search.mapper.orm.search.dsl.query.impl.HibernateOrmSearchQueryResultDefinitionContextImpl;
import org.hibernate.search.mapper.orm.search.loading.context.impl.HibernateOrmLoadingContext;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderBuilder;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.writing.SearchWriter;
import org.hibernate.search.mapper.orm.writing.impl.SearchWriterImpl;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;

public class SearchScopeImpl<E>
implements SearchScope<E>,
org.hibernate.search.mapper.orm.search.SearchScope<E> {
    private final HibernateOrmScopeMappingContext mappingContext;
    private final HibernateOrmScopeSessionContext sessionContext;
    private final PojoScopeDelegate<EntityReference, E, HibernateOrmScopeIndexedTypeContext<? extends E>> delegate;

    public SearchScopeImpl(HibernateOrmScopeMappingContext mappingContext, HibernateOrmScopeSessionContext sessionContext, PojoScopeDelegate<EntityReference, E, HibernateOrmScopeIndexedTypeContext<? extends E>> delegate) {
        this.mappingContext = mappingContext;
        this.sessionContext = sessionContext;
        this.delegate = delegate;
    }

    @Override
    public HibernateOrmSearchQueryResultDefinitionContext<E> search() {
        SessionImplementor sessionImplementor = this.sessionContext.getSession();
        EntityLoaderBuilder entityLoaderBuilder = new EntityLoaderBuilder((Session)sessionImplementor, this.delegate.getIncludedIndexedTypes());
        MutableEntityLoadingOptions loadingOptions = new MutableEntityLoadingOptions();
        HibernateOrmLoadingContext.Builder loadingContextBuilder = new HibernateOrmLoadingContext.Builder(this.sessionContext, entityLoaderBuilder, loadingOptions);
        return new HibernateOrmSearchQueryResultDefinitionContextImpl(this.delegate.search(loadingContextBuilder), loadingOptions);
    }

    @Override
    public SearchPredicateFactoryContext predicate() {
        return this.delegate.predicate();
    }

    @Override
    public SearchSortFactoryContext sort() {
        return this.delegate.sort();
    }

    @Override
    public SearchProjectionFactoryContext<EntityReference, E> projection() {
        return this.delegate.projection();
    }

    @Override
    public SearchWriter writer() {
        return new SearchWriterImpl(this.delegate.executor());
    }

    @Override
    public MassIndexer massIndexer() {
        return new MassIndexerImpl(this.sessionContext.getSession().getFactory(), this.mappingContext, this.delegate.getIncludedIndexedTypes(), this.sessionContext.getDetachedSessionContext(), this.delegate.executor());
    }
}

