/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.Session;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;

public class HibernateOrmSingleTypeByIdEntityLoader<E>
implements HibernateOrmComposableEntityLoader<EntityReference, E> {
    private final Session session;
    private final Class<E> entityType;
    private final MutableEntityLoadingOptions loadingOptions;
    private MultiIdentifierLoadAccess<E> multiAccess;

    public HibernateOrmSingleTypeByIdEntityLoader(Session session, Class<E> entityType, MutableEntityLoadingOptions loadingOptions) {
        this.session = session;
        this.entityType = entityType;
        this.loadingOptions = loadingOptions;
    }

    public List<E> loadBlocking(List<EntityReference> references) {
        return this.loadEntities(references);
    }

    @Override
    public void loadBlocking(List<EntityReference> references, Map<? super EntityReference, ? super E> objectsByReference) {
        List<E> loadedObjects = this.loadEntities(references);
        Iterator<EntityReference> referencesIterator = references.iterator();
        Iterator<E> loadedObjectIterator = loadedObjects.iterator();
        while (referencesIterator.hasNext()) {
            EntityReference reference = referencesIterator.next();
            E loadedObject = loadedObjectIterator.next();
            if (loadedObject == null) continue;
            objectsByReference.put(reference, loadedObject);
        }
    }

    private List<E> loadEntities(List<EntityReference> references) {
        ArrayList<Serializable> ids = new ArrayList<Serializable>(references.size());
        for (EntityReference reference : references) {
            ids.add((Serializable)reference.getId());
        }
        return this.getMultiAccess().multiLoad(ids);
    }

    private MultiIdentifierLoadAccess<E> getMultiAccess() {
        if (this.multiAccess == null) {
            this.multiAccess = this.session.byMultipleIds(this.entityType);
        }
        this.multiAccess.withBatchSize(this.loadingOptions.getFetchSize());
        return this.multiAccess;
    }
}

