/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.Session;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;

public class HibernateOrmSingleTypeCriteriaEntityLoader<E>
implements HibernateOrmComposableEntityLoader<EntityReference, E> {
    private final Session session;
    private final Class<? extends E> entityType;
    private final SingularAttribute<? super E, ?> documentIdSourceProperty;
    private final MutableEntityLoadingOptions loadingOptions;

    public HibernateOrmSingleTypeCriteriaEntityLoader(Session session, Class<? extends E> entityType, SingularAttribute<? super E, ?> documentIdSourceProperty, MutableEntityLoadingOptions loadingOptions) {
        this.session = session;
        this.entityType = entityType;
        this.documentIdSourceProperty = documentIdSourceProperty;
        this.loadingOptions = loadingOptions;
    }

    public List<E> loadBlocking(List<EntityReference> references) {
        HashMap objectsByReference = new HashMap();
        this.loadBlocking(references, objectsByReference);
        ArrayList result = new ArrayList(references.size());
        for (EntityReference reference : references) {
            result.add(objectsByReference.get(reference));
        }
        return result;
    }

    @Override
    public void loadBlocking(List<EntityReference> references, Map<? super EntityReference, ? super E> objectsByReference) {
        HashMap<Object, EntityReference> documentIdSourceValueToReference = new HashMap<Object, EntityReference>();
        for (EntityReference reference : references) {
            documentIdSourceValueToReference.put(reference.getId(), reference);
        }
        List<EntityLoadingResult> loadingResults = this.loadEntities(documentIdSourceValueToReference.keySet());
        for (EntityLoadingResult loadingResult : loadingResults) {
            Object documentIdSourceValue = loadingResult.documentIdSourceValue;
            EntityReference reference = (EntityReference)documentIdSourceValueToReference.get(documentIdSourceValue);
            Object loadedEntity = loadingResult.loadedEntity;
            objectsByReference.put(reference, loadedEntity);
        }
    }

    private List<EntityLoadingResult> loadEntities(Collection<Object> documentIdSourceValues) {
        CriteriaBuilder criteriaBuilder = this.session.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(EntityLoadingResult.class);
        Root root = criteriaQuery.from(this.entityType);
        Path documentIdSourcePropertyInRoot = root.get(this.documentIdSourceProperty);
        criteriaQuery.select((Selection)criteriaBuilder.construct(EntityLoadingResult.class, new Selection[]{documentIdSourcePropertyInRoot, root}));
        criteriaQuery.where((Expression)documentIdSourcePropertyInRoot.in(documentIdSourceValues));
        return this.session.createQuery(criteriaQuery).setFetchSize(this.loadingOptions.getFetchSize()).getResultList();
    }

    private static class EntityLoadingResult {
        private final Object documentIdSourceValue;
        private final Object loadedEntity;

        public EntityLoadingResult(Object documentIdSourceValue, Object loadedEntity) {
            this.documentIdSourceValue = documentIdSourceValue;
            this.loadedEntity = loadedEntity;
        }
    }
}

