/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import org.hibernate.search.mapper.orm.session.SearchSessionWritePlan;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;

final class SearchSessionWritePlanImpl
implements SearchSessionWritePlan {
    private final HibernateOrmSearchSession searchSession;

    SearchSessionWritePlanImpl(HibernateOrmSearchSession searchSession) {
        this.searchSession = searchSession;
    }

    @Override
    public void addOrUpdate(Object entity) {
        this.getCurrentWorkPlan().update(entity);
    }

    @Override
    public void delete(Object entity) {
        this.getCurrentWorkPlan().delete(entity);
    }

    @Override
    public void purge(Class<?> entityClass, Object providedId) {
        this.getCurrentWorkPlan().purge(entityClass, providedId);
    }

    @Override
    public void process() {
        this.getCurrentWorkPlan().prepare();
    }

    @Override
    public void execute() {
        this.searchSession.getAutomaticIndexingSynchronizationStrategy().handleFuture(this.getCurrentWorkPlan().execute());
    }

    private PojoWorkPlan getCurrentWorkPlan() {
        this.searchSession.checkOrmSessionIsOpen();
        return this.searchSession.getCurrentWorkPlan();
    }
}

