package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Locale;
import org.hibernate.SessionFactory;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.jboss.logging.BasicLogger;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.mapping.Value;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void indexingEntities(final long count) {
        super.log.logf(FQCN, INFO, null, indexingEntities$str(), count);
    }
    private static final String indexingEntities = "HSEARCH000027: Going to reindex %d entities";
    protected String indexingEntities$str() {
        return indexingEntities;
    }
    @Override
    public final void indexingEntitiesCompleted(final long nbrOfEntities) {
        super.log.logf(FQCN, INFO, null, indexingEntitiesCompleted$str(), nbrOfEntities);
    }
    private static final String indexingEntitiesCompleted = "HSEARCH000028: Reindexed %1$d entities";
    protected String indexingEntitiesCompleted$str() {
        return indexingEntitiesCompleted;
    }
    @Override
    public final void indexingDocumentsCompleted(final long doneCount, final long elapsedMs) {
        super.log.logf(FQCN, INFO, null, indexingDocumentsCompleted$str(), doneCount, elapsedMs);
    }
    private static final String indexingDocumentsCompleted = "HSEARCH000030: %1$d documents indexed in %2$d ms";
    protected String indexingDocumentsCompleted$str() {
        return indexingDocumentsCompleted;
    }
    @Override
    public final void indexingSpeed(final float estimateSpeed, final float estimatePercentileComplete) {
        super.log.logf(FQCN, INFO, null, indexingSpeed$str(), estimateSpeed, estimatePercentileComplete);
    }
    private static final String indexingSpeed = "HSEARCH000031: Indexing speed: %1$f documents/second; progress: %2$.2f%%";
    protected String indexingSpeed$str() {
        return indexingSpeed;
    }
    @Override
    public final void cannotGuessTransactionStatus(final Exception e) {
        super.log.logf(FQCN, WARN, e, cannotGuessTransactionStatus$str());
    }
    private static final String cannotGuessTransactionStatus = "HSEARCH000036: Cannot guess the Transaction Status: not starting a JTA transaction";
    protected String cannotGuessTransactionStatus$str() {
        return cannotGuessTransactionStatus;
    }
    @Override
    public final void interruptedBatchIndexing() {
        super.log.logf(FQCN, ERROR, null, interruptedBatchIndexing$str());
    }
    private static final String interruptedBatchIndexing = "HSEARCH000062: Batch indexing was interrupted";
    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }
    @Override
    public final void errorRollingBackTransaction(final String message, final Exception e1) {
        super.log.logf(FQCN, ERROR, e1, errorRollingBackTransaction$str(), message);
    }
    private static final String errorRollingBackTransaction = "HSEARCH000065: Error while rolling back transaction after %1$s";
    protected String errorRollingBackTransaction$str() {
        return errorRollingBackTransaction;
    }
    private static final String massIndexerUnexpectedErrorMessage = "HSEARCH000116: Unexpected error during MassIndexer operation";
    protected String massIndexerUnexpectedErrorMessage$str() {
        return massIndexerUnexpectedErrorMessage;
    }
    @Override
    public final String massIndexerUnexpectedErrorMessage() {
        return String.format(getLoggingLocale(), massIndexerUnexpectedErrorMessage$str());
    }
    private static final String massIndexerUnableToIndexInstance = "HSEARCH000183: Unable to index instance of type %s while batch indexing: %s";
    protected String massIndexerUnableToIndexInstance$str() {
        return massIndexerUnableToIndexInstance;
    }
    @Override
    public final String massIndexerUnableToIndexInstance(final String clazz, final String value) {
        return String.format(getLoggingLocale(), massIndexerUnableToIndexInstance$str(), clazz, value);
    }
    private static final String massIndexerExceptionWhileFetchingIds = "HSEARCH000211: An exception occurred while the MassIndexer was fetching the primary identifiers list";
    protected String massIndexerExceptionWhileFetchingIds$str() {
        return massIndexerExceptionWhileFetchingIds;
    }
    @Override
    public final String massIndexerExceptionWhileFetchingIds() {
        return String.format(getLoggingLocale(), massIndexerExceptionWhileFetchingIds$str());
    }
    private static final String massIndexerExceptionWhileTransformingIds = "HSEARCH000212: An exception occurred while the MassIndexer was transforming identifiers to Lucene Documents";
    protected String massIndexerExceptionWhileTransformingIds$str() {
        return massIndexerExceptionWhileTransformingIds;
    }
    @Override
    public final String massIndexerExceptionWhileTransformingIds() {
        return String.format(getLoggingLocale(), massIndexerExceptionWhileTransformingIds$str());
    }
    private static final String transactionNotActiveWhileProducingIdsForBatchIndexing = "HSEARCH000276: No transaction is active while indexing entity type '%1$s'; Consider increasing the connection time-out";
    protected String transactionNotActiveWhileProducingIdsForBatchIndexing$str() {
        return transactionNotActiveWhileProducingIdsForBatchIndexing;
    }
    @Override
    public final SearchException transactionNotActiveWhileProducingIdsForBatchIndexing(final Class<?> entityType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), transactionNotActiveWhileProducingIdsForBatchIndexing$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(entityType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String hibernateSearchNotInitialized = "HSEARCH800001: Hibernate Search was not initialized.";
    protected String hibernateSearchNotInitialized$str() {
        return hibernateSearchNotInitialized;
    }
    @Override
    public final SearchException hibernateSearchNotInitialized() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSearchNotInitialized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedSearchHitType = "HSEARCH800002: Unexpected entity type for a query hit: %1$s. Expected one of %2$s.";
    protected String unexpectedSearchHitType$str() {
        return unexpectedSearchHitType;
    }
    @Override
    public final SearchException unexpectedSearchHitType(final Class<?> entityType, final java.util.Collection<? extends Class<?>> expectedTypes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedSearchHitType$str(), entityType, expectedTypes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAutomaticIndexingStrategyName = "HSEARCH800003: Invalid automatic indexing strategy name: '%1$s'. Valid names are: %2$s.";
    protected String invalidAutomaticIndexingStrategyName$str() {
        return invalidAutomaticIndexingStrategyName;
    }
    @Override
    public final SearchException invalidAutomaticIndexingStrategyName(final String invalidRepresentation, final java.util.List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAutomaticIndexingStrategyName$str(), invalidRepresentation, validRepresentations));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void configurationPropertyTrackingDisabled() {
        super.log.logf(FQCN, INFO, null, configurationPropertyTrackingDisabled$str());
    }
    private static final String configurationPropertyTrackingDisabled = "HSEARCH800005: Configuration property tracking is disabled; unused properties will not be logged.";
    protected String configurationPropertyTrackingDisabled$str() {
        return configurationPropertyTrackingDisabled;
    }
    @Override
    public final void configurationPropertyTrackingUnusedProperties(final java.util.Set<String> propertyKeys, final String disableWarningKey) {
        super.log.logf(FQCN, WARN, null, configurationPropertyTrackingUnusedProperties$str(), propertyKeys, disableWarningKey);
    }
    private static final String configurationPropertyTrackingUnusedProperties = "HSEARCH800006: Some properties in the Hibernate Search configuration were not used; there might be misspelled property keys in your configuration. Unused properties were: %1$s. To disable this warning, set the property '%2$s' to false.";
    protected String configurationPropertyTrackingUnusedProperties$str() {
        return configurationPropertyTrackingUnusedProperties;
    }
    private static final String unknownPathForDirtyChecking = "HSEARCH800007: Path '%2$s' on entity type '%1$s' cannot be resolved using Hibernate ORM metadata. Please check that this path points to a persisted value.";
    protected String unknownPathForDirtyChecking$str() {
        return unknownPathForDirtyChecking;
    }
    @Override
    public final SearchException unknownPathForDirtyChecking(final Class<?> entityType, final PojoModelPath path, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownPathForDirtyChecking$str(), entityType, path), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unreportedPathForDirtyChecking = "HSEARCH800008: Path '%2$s' on entity type '%1$s' can be resolved using Hibernate ORM metadata, but points to value '%3$s' that will never be reported as dirty by Hibernate ORM. Please check that this path points to a persisted value, and in particular not an embedded property.";
    protected String unreportedPathForDirtyChecking$str() {
        return unreportedPathForDirtyChecking;
    }
    @Override
    public final SearchException unreportedPathForDirtyChecking(final Class<?> entityType, final PojoModelPath path, final Value value) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unreportedPathForDirtyChecking$str(), entityType, path, value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidContainerExtractorForDirtyChecking = "HSEARCH800009: Container value extractor with name '%2$s' cannot be applied to Hibernate ORM metadata node of type '%1$s'.";
    protected String invalidContainerExtractorForDirtyChecking$str() {
        return invalidContainerExtractorForDirtyChecking;
    }
    @Override
    public final SearchException invalidContainerExtractorForDirtyChecking(final Class<?> ormMappingClass, final String extractorName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContainerExtractorForDirtyChecking$str(), ormMappingClass, extractorName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFindReadableProperty = "HSEARCH800010: Unable to find a readable property '%2$s' on type '%1$s'.";
    protected String cannotFindReadableProperty$str() {
        return cannotFindReadableProperty;
    }
    @Override
    public final SearchException cannotFindReadableProperty(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindReadableProperty$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String usingDifferentSessionFactories = "HSEARCH800011: Mapping service cannot create a SearchSession using a different session factory. Expected: '%1$s'. In use: '%2$s'.";
    protected String usingDifferentSessionFactories$str() {
        return usingDifferentSessionFactories;
    }
    @Override
    public final SearchException usingDifferentSessionFactories(final SessionFactory expectedSessionFactory, final SessionFactory usedSessionFactory) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), usingDifferentSessionFactories$str(), expectedSessionFactory, usedSessionFactory));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorRetrievingPropertyTypeModel = "HSEARCH800012: Exception while retrieving property type model for '%1$s' on '%2$s'.";
    protected String errorRetrievingPropertyTypeModel$str() {
        return errorRetrievingPropertyTypeModel;
    }
    @Override
    public final SearchException errorRetrievingPropertyTypeModel(final String propertyModelName, final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> parentTypeModel, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingPropertyTypeModel$str(), propertyModelName, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(parentTypeModel)), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interruptedBatchIndexingException = "HSEARCH800013: Interrupted on batch Indexing; index will be left in unknown state!";
    protected String interruptedBatchIndexingException$str() {
        return interruptedBatchIndexingException;
    }
    @Override
    public final SearchException interruptedBatchIndexingException(final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), interruptedBatchIndexingException$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidReflectionStrategyName = "HSEARCH800015: Invalid reflection strategy name: '%1$s'. Valid names are: %2$s.";
    protected String invalidReflectionStrategyName$str() {
        return invalidReflectionStrategyName;
    }
    @Override
    public final SearchException invalidReflectionStrategyName(final String invalidRepresentation, final java.util.List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidReflectionStrategyName$str(), invalidRepresentation, validRepresentations));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String hibernateSessionAccessError = "HSEARCH800016: Error trying to access Hibernate ORM session.";
    protected String hibernateSessionAccessError$str() {
        return hibernateSessionAccessError;
    }
    @Override
    public final SearchException hibernateSessionAccessError(final IllegalStateException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSessionAccessError$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String hibernateSessionIsClosed = "HSEARCH800017: Underlying Hibernate ORM Session seems to be closed.";
    protected String hibernateSessionIsClosed$str() {
        return hibernateSessionIsClosed;
    }
    @Override
    public final SearchException hibernateSessionIsClosed(final IllegalStateException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSessionIsClosed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAutomaticIndexingSynchronizationStrategyName = "HSEARCH800018: Invalid automatic indexing synchronization strategy name: '%1$s'. Valid names are: %2$s.";
    protected String invalidAutomaticIndexingSynchronizationStrategyName$str() {
        return invalidAutomaticIndexingSynchronizationStrategyName;
    }
    @Override
    public final SearchException invalidAutomaticIndexingSynchronizationStrategyName(final String invalidRepresentation, final java.util.List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAutomaticIndexingSynchronizationStrategyName$str(), invalidRepresentation, validRepresentations));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(final Class<?> entityType, final EntityLoadingCacheLookupStrategy cacheLookupStrategy) {
        super.log.logf(FQCN, DEBUG, null, skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(entityType), cacheLookupStrategy);
    }
    private static final String skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader = "HSEARCH800019: The entity loader for '%1$s' will ignore the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.";
    protected String skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str() {
        return skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader;
    }
    @Override
    public final void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(final Class<?> entityType) {
        super.log.logf(FQCN, DEBUG, null, skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(entityType));
    }
    private static final String skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader = "HSEARCH800020: The entity loader for '%1$s' will ignore the second-level cache  even though it was instructed to use it, because caching is not enabled for this entity type.";
    protected String skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str() {
        return skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader;
    }
    private static final String hibernateSearchEventListenerNotFound = "HSEARCH800021: Hibernate Search event listener not found.";
    protected String hibernateSearchEventListenerNotFound$str() {
        return hibernateSearchEventListenerNotFound;
    }
    @Override
    public final SearchException hibernateSearchEventListenerNotFound() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSearchEventListenerNotFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
