/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.hibernate.mapping.Value;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String indexingEntities = "HSEARCH000027: Going to reindex %d entities";
    private static final String indexingEntitiesCompleted = "HSEARCH000028: Reindexed %1$d entities";
    private static final String indexingDocumentsCompleted = "HSEARCH000030: %1$d documents indexed in %2$d ms";
    private static final String indexingSpeed = "HSEARCH000031: Indexing speed: %1$f documents/second; progress: %2$.2f%%";
    private static final String cannotGuessTransactionStatus = "HSEARCH000036: Cannot guess the Transaction Status: not starting a JTA transaction";
    private static final String interruptedBatchIndexing = "HSEARCH000062: Batch indexing was interrupted";
    private static final String errorRollingBackTransaction = "HSEARCH000065: Error while rolling back transaction after %1$s";
    private static final String massIndexerUnexpectedErrorMessage = "HSEARCH000116: Unexpected error during MassIndexer operation";
    private static final String massIndexerUnableToIndexInstance = "HSEARCH000183: Unable to index instance of type %s while batch indexing: %s";
    private static final String massIndexerExceptionWhileFetchingIds = "HSEARCH000211: An exception occurred while the MassIndexer was fetching the primary identifiers list";
    private static final String massIndexerExceptionWhileTransformingIds = "HSEARCH000212: An exception occurred while the MassIndexer was transforming identifiers to Lucene Documents";
    private static final String transactionNotActiveWhileProducingIdsForBatchIndexing = "HSEARCH000276: No transaction is active while indexing entity type '%1$s'; Consider increasing the connection time-out";
    private static final String hibernateSearchNotInitialized = "HSEARCH800001: Hibernate Search was not initialized.";
    private static final String unexpectedSearchHitType = "HSEARCH800002: Unexpected entity type for a query hit: %1$s. Expected one of %2$s.";
    private static final String invalidAutomaticIndexingStrategyName = "HSEARCH800003: Invalid automatic indexing strategy name: '%1$s'. Valid names are: %2$s.";
    private static final String configurationPropertyTrackingDisabled = "HSEARCH800005: Configuration property tracking is disabled; unused properties will not be logged.";
    private static final String configurationPropertyTrackingUnusedProperties = "HSEARCH800006: Some properties in the Hibernate Search configuration were not used; there might be misspelled property keys in your configuration. Unused properties were: %1$s. To disable this warning, set the property '%2$s' to false.";
    private static final String unknownPathForDirtyChecking = "HSEARCH800007: Path '%2$s' on entity type '%1$s' cannot be resolved using Hibernate ORM metadata. Please check that this path points to a persisted value.";
    private static final String unreportedPathForDirtyChecking = "HSEARCH800008: Path '%2$s' on entity type '%1$s' can be resolved using Hibernate ORM metadata, but points to value '%3$s' that will never be reported as dirty by Hibernate ORM. Please check that this path points to a persisted value, and in particular not an embedded property.";
    private static final String invalidContainerExtractorForDirtyChecking = "HSEARCH800009: Container value extractor with name '%2$s' cannot be applied to Hibernate ORM metadata node of type '%1$s'.";
    private static final String cannotFindReadableProperty = "HSEARCH800010: Unable to find a readable property '%2$s' on type '%1$s'.";
    private static final String usingDifferentSessionFactories = "HSEARCH800011: Mapping service cannot create a SearchSession using a different session factory. Expected: '%1$s'. In use: '%2$s'.";
    private static final String errorRetrievingPropertyTypeModel = "HSEARCH800012: Exception while retrieving property type model for '%1$s' on '%2$s'.";
    private static final String interruptedBatchIndexingException = "HSEARCH800013: Interrupted on batch Indexing; index will be left in unknown state!";
    private static final String invalidReflectionStrategyName = "HSEARCH800015: Invalid reflection strategy name: '%1$s'. Valid names are: %2$s.";
    private static final String hibernateSessionAccessError = "HSEARCH800016: Error trying to access Hibernate ORM session.";
    private static final String hibernateSessionIsClosed = "HSEARCH800017: Underlying Hibernate ORM Session seems to be closed.";
    private static final String invalidAutomaticIndexingSynchronizationStrategyName = "HSEARCH800018: Invalid automatic indexing synchronization strategy name: '%1$s'. Valid names are: %2$s.";
    private static final String skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader = "HSEARCH800019: The entity loader for '%1$s' will ignore the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.";
    private static final String skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader = "HSEARCH800020: The entity loader for '%1$s' will ignore the second-level cache  even though it was instructed to use it, because caching is not enabled for this entity type.";
    private static final String hibernateSearchEventListenerNotFound = "HSEARCH800021: Hibernate Search event listener not found.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void indexingEntities(long count) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntities$str(), (Object)count);
    }

    protected String indexingEntities$str() {
        return indexingEntities;
    }

    @Override
    public final void indexingEntitiesCompleted(long nbrOfEntities) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntitiesCompleted$str(), (Object)nbrOfEntities);
    }

    protected String indexingEntitiesCompleted$str() {
        return indexingEntitiesCompleted;
    }

    @Override
    public final void indexingDocumentsCompleted(long doneCount, long elapsedMs) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingDocumentsCompleted$str(), (Object)doneCount, (Object)elapsedMs);
    }

    protected String indexingDocumentsCompleted$str() {
        return indexingDocumentsCompleted;
    }

    @Override
    public final void indexingSpeed(float estimateSpeed, float estimatePercentileComplete) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingSpeed$str(), (Object)Float.valueOf(estimateSpeed), (Object)Float.valueOf(estimatePercentileComplete));
    }

    protected String indexingSpeed$str() {
        return indexingSpeed;
    }

    @Override
    public final void cannotGuessTransactionStatus(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.cannotGuessTransactionStatus$str(), new Object[0]);
    }

    protected String cannotGuessTransactionStatus$str() {
        return cannotGuessTransactionStatus;
    }

    @Override
    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }

    @Override
    public final void errorRollingBackTransaction(String message, Exception e1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e1, this.errorRollingBackTransaction$str(), (Object)message);
    }

    protected String errorRollingBackTransaction$str() {
        return errorRollingBackTransaction;
    }

    protected String massIndexerUnexpectedErrorMessage$str() {
        return massIndexerUnexpectedErrorMessage;
    }

    @Override
    public final String massIndexerUnexpectedErrorMessage() {
        return String.format(this.getLoggingLocale(), this.massIndexerUnexpectedErrorMessage$str(), new Object[0]);
    }

    protected String massIndexerUnableToIndexInstance$str() {
        return massIndexerUnableToIndexInstance;
    }

    @Override
    public final String massIndexerUnableToIndexInstance(String clazz, String value) {
        return String.format(this.getLoggingLocale(), this.massIndexerUnableToIndexInstance$str(), clazz, value);
    }

    protected String massIndexerExceptionWhileFetchingIds$str() {
        return massIndexerExceptionWhileFetchingIds;
    }

    @Override
    public final String massIndexerExceptionWhileFetchingIds() {
        return String.format(this.getLoggingLocale(), this.massIndexerExceptionWhileFetchingIds$str(), new Object[0]);
    }

    protected String massIndexerExceptionWhileTransformingIds$str() {
        return massIndexerExceptionWhileTransformingIds;
    }

    @Override
    public final String massIndexerExceptionWhileTransformingIds() {
        return String.format(this.getLoggingLocale(), this.massIndexerExceptionWhileTransformingIds$str(), new Object[0]);
    }

    protected String transactionNotActiveWhileProducingIdsForBatchIndexing$str() {
        return transactionNotActiveWhileProducingIdsForBatchIndexing;
    }

    @Override
    public final SearchException transactionNotActiveWhileProducingIdsForBatchIndexing(Class<?> entityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.transactionNotActiveWhileProducingIdsForBatchIndexing$str(), new ClassFormatter(entityType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hibernateSearchNotInitialized$str() {
        return hibernateSearchNotInitialized;
    }

    @Override
    public final SearchException hibernateSearchNotInitialized() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSearchNotInitialized$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedSearchHitType$str() {
        return unexpectedSearchHitType;
    }

    @Override
    public final SearchException unexpectedSearchHitType(Class<?> entityType, Collection<? extends Class<?>> expectedTypes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedSearchHitType$str(), entityType, expectedTypes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAutomaticIndexingStrategyName$str() {
        return invalidAutomaticIndexingStrategyName;
    }

    @Override
    public final SearchException invalidAutomaticIndexingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAutomaticIndexingStrategyName$str(), invalidRepresentation, validRepresentations));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void configurationPropertyTrackingDisabled() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.configurationPropertyTrackingDisabled$str(), new Object[0]);
    }

    protected String configurationPropertyTrackingDisabled$str() {
        return configurationPropertyTrackingDisabled;
    }

    @Override
    public final void configurationPropertyTrackingUnusedProperties(Set<String> propertyKeys, String disableWarningKey) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.configurationPropertyTrackingUnusedProperties$str(), propertyKeys, (Object)disableWarningKey);
    }

    protected String configurationPropertyTrackingUnusedProperties$str() {
        return configurationPropertyTrackingUnusedProperties;
    }

    protected String unknownPathForDirtyChecking$str() {
        return unknownPathForDirtyChecking;
    }

    @Override
    public final SearchException unknownPathForDirtyChecking(Class<?> entityType, PojoModelPath path, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownPathForDirtyChecking$str(), entityType, path), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unreportedPathForDirtyChecking$str() {
        return unreportedPathForDirtyChecking;
    }

    @Override
    public final SearchException unreportedPathForDirtyChecking(Class<?> entityType, PojoModelPath path, Value value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unreportedPathForDirtyChecking$str(), entityType, path, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidContainerExtractorForDirtyChecking$str() {
        return invalidContainerExtractorForDirtyChecking;
    }

    @Override
    public final SearchException invalidContainerExtractorForDirtyChecking(Class<?> ormMappingClass, String extractorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidContainerExtractorForDirtyChecking$str(), ormMappingClass, extractorName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindReadableProperty$str() {
        return cannotFindReadableProperty;
    }

    @Override
    public final SearchException cannotFindReadableProperty(PojoRawTypeModel<?> typeModel, String propertyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindReadableProperty$str(), new PojoTypeModelFormatter(typeModel), propertyName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String usingDifferentSessionFactories$str() {
        return usingDifferentSessionFactories;
    }

    @Override
    public final SearchException usingDifferentSessionFactories(SessionFactory expectedSessionFactory, SessionFactory usedSessionFactory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.usingDifferentSessionFactories$str(), expectedSessionFactory, usedSessionFactory));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorRetrievingPropertyTypeModel$str() {
        return errorRetrievingPropertyTypeModel;
    }

    @Override
    public final SearchException errorRetrievingPropertyTypeModel(String propertyModelName, PojoRawTypeModel<?> parentTypeModel, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingPropertyTypeModel$str(), propertyModelName, new PojoTypeModelFormatter(parentTypeModel)), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String interruptedBatchIndexingException$str() {
        return interruptedBatchIndexingException;
    }

    @Override
    public final SearchException interruptedBatchIndexingException(Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.interruptedBatchIndexingException$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidReflectionStrategyName$str() {
        return invalidReflectionStrategyName;
    }

    @Override
    public final SearchException invalidReflectionStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidReflectionStrategyName$str(), invalidRepresentation, validRepresentations));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hibernateSessionAccessError$str() {
        return hibernateSessionAccessError;
    }

    @Override
    public final SearchException hibernateSessionAccessError(IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionAccessError$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hibernateSessionIsClosed$str() {
        return hibernateSessionIsClosed;
    }

    @Override
    public final SearchException hibernateSessionIsClosed(IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionIsClosed$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAutomaticIndexingSynchronizationStrategyName$str() {
        return invalidAutomaticIndexingSynchronizationStrategyName;
    }

    @Override
    public final SearchException invalidAutomaticIndexingSynchronizationStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAutomaticIndexingSynchronizationStrategyName$str(), invalidRepresentation, validRepresentations));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(Class<?> entityType, EntityLoadingCacheLookupStrategy cacheLookupStrategy) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str(), (Object)new ClassFormatter(entityType), (Object)cacheLookupStrategy);
    }

    protected String skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str() {
        return skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader;
    }

    @Override
    public final void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(Class<?> entityType) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str(), (Object)new ClassFormatter(entityType));
    }

    protected String skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str() {
        return skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader;
    }

    protected String hibernateSearchEventListenerNotFound$str() {
        return hibernateSearchEventListenerNotFound;
    }

    @Override
    public final SearchException hibernateSearchEventListenerNotFound() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSearchEventListenerNotFound$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

