/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.CacheMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.search.engine.mapper.session.context.spi.DetachedSessionContextImplementor;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchIndexingWorkspace;
import org.hibernate.search.mapper.orm.massindexing.impl.ErrorHandledRunnable;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.massindexing.monitor.MassIndexingMonitor;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkExecutor;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Executors;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class BatchCoordinator
extends ErrorHandledRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SessionFactoryImplementor sessionFactory;
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final DetachedSessionContextImplementor sessionContext;
    private final Set<Class<?>> rootEntities;
    private final PojoScopeWorkExecutor scopeWorkExecutor;
    private final int typesToIndexInParallel;
    private final int documentBuilderThreads;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final boolean optimizeAtEnd;
    private final boolean purgeAtStart;
    private final boolean optimizeAfterPurge;
    private final CountDownLatch endAllSignal;
    private final MassIndexingMonitor monitor;
    private final long objectsLimit;
    private final int idFetchSize;
    private final Integer transactionTimeout;
    private final List<Future<?>> indexingTasks = new ArrayList();

    public BatchCoordinator(SessionFactoryImplementor sessionFactory, HibernateOrmMassIndexingMappingContext mappingContext, DetachedSessionContextImplementor sessionContext, Set<Class<?>> rootEntities, PojoScopeWorkExecutor scopeWorkExecutor, int typesToIndexInParallel, int documentBuilderThreads, CacheMode cacheMode, int objectLoadingBatchSize, long objectsLimit, boolean optimizeAtEnd, boolean purgeAtStart, boolean optimizeAfterPurge, MassIndexingMonitor monitor, int idFetchSize, Integer transactionTimeout) {
        this.sessionFactory = sessionFactory;
        this.mappingContext = mappingContext;
        this.sessionContext = sessionContext;
        this.rootEntities = rootEntities;
        this.scopeWorkExecutor = scopeWorkExecutor;
        this.idFetchSize = idFetchSize;
        this.transactionTimeout = transactionTimeout;
        this.typesToIndexInParallel = typesToIndexInParallel;
        this.documentBuilderThreads = documentBuilderThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.optimizeAtEnd = optimizeAtEnd;
        this.purgeAtStart = purgeAtStart;
        this.optimizeAfterPurge = optimizeAfterPurge;
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
        this.endAllSignal = new CountDownLatch(rootEntities.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithErrorHandler() {
        if (!this.indexingTasks.isEmpty()) {
            throw new AssertionFailure("BatchCoordinator instance not expected to be reused - indexingTasks should be empty");
        }
        try {
            this.beforeBatch();
            this.doBatchWork();
            this.afterBatch();
        }
        catch (InterruptedException e) {
            log.interruptedBatchIndexing();
            for (Future<?> task : this.indexingTasks) {
                if (task.isDone()) continue;
                task.cancel(true);
            }
            this.afterBatchOnInterruption();
            Thread.currentThread().interrupt();
        }
        finally {
            this.monitor.indexingCompleted();
        }
    }

    private void doBatchWork() throws InterruptedException {
        ThreadPoolExecutor executor = Executors.newFixedThreadPool((int)this.typesToIndexInParallel, (String)"BatchIndexingWorkspace");
        for (Class<?> type : this.rootEntities) {
            this.indexingTasks.add(executor.submit(this.createBatchIndexingWorkspace(type)));
        }
        executor.shutdown();
        this.endAllSignal.await();
    }

    private <E> BatchIndexingWorkspace<E, ?> createBatchIndexingWorkspace(Class<E> indexedType) {
        EntityTypeDescriptor indexTypeModel = this.sessionFactory.getMetamodel().entity(indexedType);
        SingularAttribute idAttributeOfIndexedType = indexTypeModel.getId(indexTypeModel.getIdType().getJavaType());
        return new BatchIndexingWorkspace(this.sessionFactory, this.mappingContext, this.sessionContext, indexedType, idAttributeOfIndexedType, this.documentBuilderThreads, this.cacheMode, this.objectLoadingBatchSize, this.endAllSignal, this.monitor, this.objectsLimit, this.idFetchSize, this.transactionTimeout);
    }

    private void afterBatch() {
        if (this.optimizeAtEnd) {
            this.scopeWorkExecutor.optimize().join();
        }
        this.scopeWorkExecutor.flush().join();
    }

    private void afterBatchOnInterruption() {
        this.scopeWorkExecutor.flush().join();
    }

    private void beforeBatch() {
        if (this.purgeAtStart) {
            this.scopeWorkExecutor.purge().join();
            if (this.optimizeAfterPurge) {
                this.scopeWorkExecutor.optimize().join();
            }
        }
    }
}

