/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.CacheMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.DetachedSessionContextImplementor;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchCoordinator;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.massindexing.monitor.MassIndexingMonitor;
import org.hibernate.search.mapper.orm.massindexing.monitor.impl.SimpleIndexingProgressMonitor;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkExecutor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class MassIndexerImpl
implements MassIndexer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final SessionFactoryImplementor sessionFactory;
    private final DetachedSessionContextImplementor sessionContext;
    private final Set<Class<?>> rootEntities;
    private final PojoScopeWorkExecutor scopeWorkExecutor;
    private int typesToIndexInParallel = 1;
    private int documentBuilderThreads = 6;
    private int objectLoadingBatchSize = 10;
    private long objectsLimit = 0L;
    private CacheMode cacheMode = CacheMode.IGNORE;
    private boolean optimizeAtEnd = true;
    private boolean purgeAtStart = true;
    private boolean optimizeAfterPurge = true;
    private MassIndexingMonitor monitor;
    private int idFetchSize = 100;
    private Integer idLoadingTransactionTimeout;

    public MassIndexerImpl(SessionFactoryImplementor sessionFactory, HibernateOrmMassIndexingMappingContext mappingContext, Set<? extends HibernateOrmMassIndexingIndexedTypeContext<?>> targetedIndexedTypes, DetachedSessionContextImplementor sessionContext, PojoScopeWorkExecutor scopeWorkExecutor) {
        this.sessionFactory = sessionFactory;
        this.mappingContext = mappingContext;
        this.sessionContext = sessionContext;
        this.rootEntities = MassIndexerImpl.toRootEntities(targetedIndexedTypes);
        this.scopeWorkExecutor = scopeWorkExecutor;
        this.monitor = new SimpleIndexingProgressMonitor();
    }

    private static Set<Class<?>> toRootEntities(Set<? extends HibernateOrmMassIndexingIndexedTypeContext<?>> targetedIndexedTypeContexts) {
        LinkedHashSet cleaned = new LinkedHashSet();
        HashSet<Class> toRemove = new HashSet<Class>();
        for (HibernateOrmMassIndexingIndexedTypeContext<?> typeContext : targetedIndexedTypeContexts) {
            Class<?> type = typeContext.getJavaClass();
            boolean typeIsOk = true;
            for (Class clazz : cleaned) {
                if (clazz.isAssignableFrom(type)) {
                    typeIsOk = false;
                    break;
                }
                if (!type.isAssignableFrom(clazz)) continue;
                toRemove.add(clazz);
            }
            if (!typeIsOk) continue;
            cleaned.add(type);
        }
        cleaned.removeAll(toRemove);
        log.debugf("Targets for indexing job: %s", cleaned);
        return cleaned;
    }

    @Override
    public MassIndexer typesToIndexInParallel(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.typesToIndexInParallel = Math.min(numberOfThreads, this.rootEntities.size());
        return this;
    }

    @Override
    public MassIndexer cacheMode(CacheMode cacheMode) {
        if (cacheMode == null) {
            throw new IllegalArgumentException("cacheMode must not be null");
        }
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public MassIndexer threadsToLoadObjects(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.documentBuilderThreads = numberOfThreads;
        return this;
    }

    @Override
    public MassIndexer batchSizeToLoadObjects(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be at least 1");
        }
        this.objectLoadingBatchSize = batchSize;
        return this;
    }

    @Override
    public MassIndexer optimizeOnFinish(boolean optimize) {
        this.optimizeAtEnd = optimize;
        return this;
    }

    @Override
    public MassIndexer optimizeAfterPurge(boolean optimize) {
        this.optimizeAfterPurge = optimize;
        return this;
    }

    @Override
    public MassIndexer purgeAllOnStart(boolean purgeAll) {
        this.purgeAtStart = purgeAll;
        return this;
    }

    @Override
    public MassIndexer transactionTimeout(int timeoutInSeconds) {
        this.idLoadingTransactionTimeout = timeoutInSeconds;
        return this;
    }

    @Override
    public CompletableFuture<?> start() {
        return CompletableFuture.runAsync(this.createCoordinator());
    }

    @Override
    public void startAndWait() throws InterruptedException {
        BatchCoordinator coordinator = this.createCoordinator();
        coordinator.run();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    protected BatchCoordinator createCoordinator() {
        return new BatchCoordinator(this.sessionFactory, this.mappingContext, this.sessionContext, this.rootEntities, this.scopeWorkExecutor, this.typesToIndexInParallel, this.documentBuilderThreads, this.cacheMode, this.objectLoadingBatchSize, this.objectsLimit, this.optimizeAtEnd, this.purgeAtStart, this.optimizeAfterPurge, this.monitor, this.idFetchSize, this.idLoadingTransactionTimeout);
    }

    @Override
    public MassIndexer limitIndexedObjectsTo(long maximum) {
        this.objectsLimit = maximum;
        return this;
    }

    @Override
    public MassIndexer idFetchSize(int idFetchSize) {
        this.idFetchSize = idFetchSize;
        return this;
    }
}

