/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.util.Collection;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.mapper.orm.search.SearchScope;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.session.SearchSessionWritePlan;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionMappingContext;

public class LazyInitSearchSession
implements SearchSession {
    private final Supplier<? extends HibernateOrmSearchSessionMappingContext> mappingContextProvider;
    private final SessionImplementor sessionImplementor;
    private HibernateOrmSearchSession delegate;

    public LazyInitSearchSession(Supplier<? extends HibernateOrmSearchSessionMappingContext> mappingContextProvider, SessionImplementor sessionImplementor) {
        this.mappingContextProvider = mappingContextProvider;
        this.sessionImplementor = sessionImplementor;
    }

    @Override
    public EntityManager toEntityManager() {
        return this.getDelegate().toEntityManager();
    }

    @Override
    public Session toOrmSession() {
        return this.getDelegate().toOrmSession();
    }

    @Override
    public <T> SearchScope<T> scope(Collection<? extends Class<? extends T>> types) {
        return this.getDelegate().scope(types);
    }

    @Override
    public SearchSessionWritePlan writePlan() {
        return this.getDelegate().writePlan();
    }

    @Override
    public void setAutomaticIndexingSynchronizationStrategy(AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        this.getDelegate().setAutomaticIndexingSynchronizationStrategy(synchronizationStrategy);
    }

    private HibernateOrmSearchSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = HibernateOrmSearchSession.get(this.mappingContextProvider.get(), this.sessionImplementor);
        }
        return this.delegate;
    }
}

