/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.query.Query;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateSearchContextProviderService;
import org.hibernate.search.mapper.orm.search.query.impl.HibernateOrmSearchQueryAdapter;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.session.impl.LazyInitSearchSession;

public final class Search {
    private Search() {
    }

    public static SearchMapping mapping(SessionFactory sessionFactory) {
        SessionFactoryImplementor sessionFactoryImpl = HibernateOrmUtils.toSessionFactoryImplementor((EntityManagerFactory)sessionFactory);
        return Search.getSearchMapping(sessionFactoryImpl);
    }

    public static SearchMapping mapping(EntityManagerFactory entityManagerFactory) {
        SessionFactoryImplementor sessionFactoryImpl = HibernateOrmUtils.toSessionFactoryImplementor(entityManagerFactory);
        return Search.getSearchMapping(sessionFactoryImpl);
    }

    public static SearchSession session(Session session) {
        SessionImplementor sessionImpl = HibernateOrmUtils.toSessionImplementor((EntityManager)session);
        return Search.createSearchSession(sessionImpl);
    }

    public static SearchSession session(EntityManager entityManager) {
        SessionImplementor sessionImpl = HibernateOrmUtils.toSessionImplementor(entityManager);
        return Search.createSearchSession(sessionImpl);
    }

    @Deprecated
    public static SearchSession getSearchSession(Session session) {
        return Search.session(session);
    }

    @Deprecated
    public static SearchSession getSearchSession(EntityManager entityManager) {
        return Search.session(entityManager);
    }

    public static <H> TypedQuery<H> toJpaQuery(SearchQuery<H> searchQuery) {
        return HibernateOrmSearchQueryAdapter.create(searchQuery);
    }

    public static <H> Query<H> toOrmQuery(SearchQuery<H> searchQuery) {
        return HibernateOrmSearchQueryAdapter.create(searchQuery);
    }

    private static SearchMapping getSearchMapping(SessionFactoryImplementor sessionFactoryImplementor) {
        HibernateSearchContextProviderService mappingContextProvider = HibernateSearchContextProviderService.get(sessionFactoryImplementor);
        return mappingContextProvider.get();
    }

    private static SearchSession createSearchSession(SessionImplementor sessionImplementor) {
        HibernateSearchContextProviderService mappingContextProvider = HibernateSearchContextProviderService.get(sessionImplementor.getSessionFactory());
        return new LazyInitSearchSession(mappingContextProvider, sessionImplementor);
    }
}

