/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmMappingConfigurationContext;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmSearchMappingConfigurer;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapperDelegate;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingPartialBuildState;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMetatadaContributor;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMapperDelegate;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingInitiator;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.util.common.impl.StreamHelper;

public class HibernateOrmMappingInitiator
extends AbstractPojoMappingInitiator<HibernateOrmMappingPartialBuildState>
implements HibernateOrmMappingConfigurationContext {
    private static final ConfigurationProperty<Boolean> MAPPING_PROCESS_ANNOTATIONS = ConfigurationProperty.forKey((String)"mapping.process_annotations").asBoolean().withDefault((Object)true).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends HibernateOrmSearchMappingConfigurer>> MAPPING_CONFIGURER = ConfigurationProperty.forKey((String)"mapping.configurer").asBeanReference(HibernateOrmSearchMappingConfigurer.class).build();
    private final Metadata metadata;
    private final HibernateOrmBootstrapIntrospector introspector;

    public static HibernateOrmMappingInitiator create(Metadata metadata, ReflectionManager reflectionManager, ConfigurationService ormConfigurationService, ConfigurationPropertySource propertySource) {
        HibernateOrmBootstrapIntrospector introspector = HibernateOrmBootstrapIntrospector.create(metadata, reflectionManager, propertySource);
        return new HibernateOrmMappingInitiator(metadata, ormConfigurationService, introspector);
    }

    private HibernateOrmMappingInitiator(Metadata metadata, ConfigurationService ormConfigurationService, HibernateOrmBootstrapIntrospector introspector) {
        super((PojoBootstrapIntrospector)introspector);
        this.metadata = metadata;
        this.introspector = introspector;
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy((Map)ormConfigurationService.getSettings());
        this.setMultiTenancyEnabled(!MultiTenancyStrategy.NONE.equals((Object)multiTenancyStrategy));
    }

    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        ConfigurationPropertySource propertySource = buildContext.getConfigurationPropertySource();
        Map persistentClasses = (Map)this.metadata.getEntityBindings().stream().filter(persistentClass -> persistentClass.getMappedClass() != null).collect(StreamHelper.toMap(PersistentClass::getEntityName, Function.identity(), TreeMap::new));
        this.addConfigurationContributor(new HibernateOrmMetatadaContributor(this.introspector, persistentClasses));
        boolean processAnnotations = (Boolean)MAPPING_PROCESS_ANNOTATIONS.get(propertySource);
        if (processAnnotations) {
            this.setAnnotatedTypeDiscoveryEnabled(true);
            AnnotationMappingConfigurationContext annotationMapping = this.annotationMapping();
            for (PersistentClass persistentClass2 : persistentClasses.values()) {
                annotationMapping.add(persistentClass2.getMappedClass());
            }
        }
        BeanResolver beanResolver = buildContext.getBeanResolver();
        MAPPING_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0)).ifPresent(holder -> {
            try (BeanHolder configurerHolder = holder;){
                ((HibernateOrmSearchMappingConfigurer)configurerHolder.get()).configure(this);
            }
        });
        super.configure(buildContext, configurationCollector);
    }

    protected PojoMapperDelegate<HibernateOrmMappingPartialBuildState> createMapperDelegate() {
        return new HibernateOrmMapperDelegate();
    }
}

