/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchTransactionalContext;
import org.hibernate.search.mapper.orm.massindexing.impl.ErrorHandledRunnable;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.massindexing.impl.IdentifierConsumerDocumentProducer;
import org.hibernate.search.mapper.orm.massindexing.impl.IdentifierProducer;
import org.hibernate.search.mapper.orm.massindexing.impl.OptionallyWrapInJTATransaction;
import org.hibernate.search.mapper.orm.massindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.mapper.orm.massindexing.monitor.MassIndexingMonitor;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Executors;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class BatchIndexingWorkspace<E, I>
extends ErrorHandledRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final DetachedBackendSessionContext sessionContext;
    private final ProducerConsumerQueue<List<I>> primaryKeyStream;
    private final int documentBuilderThreads;
    private final Class<E> indexedType;
    private final SingularAttribute<? super E, I> idAttributeOfIndexedType;
    private final CountDownLatch producerEndSignal;
    private final CountDownLatch endAllSignal;
    private final MassIndexingMonitor monitor;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final long objectsLimit;
    private final int idFetchSize;
    private final Integer transactionTimeout;
    private final List<Future<?>> tasks = new ArrayList();

    BatchIndexingWorkspace(HibernateOrmMassIndexingMappingContext mappingContext, DetachedBackendSessionContext sessionContext, Class<E> type, SingularAttribute<? super E, I> idAttributeOfIndexedType, int objectLoadingThreads, CacheMode cacheMode, int objectLoadingBatchSize, CountDownLatch endAllSignal, MassIndexingMonitor monitor, ErrorHandler errorHandler, long objectsLimit, int idFetchSize, Integer transactionTimeout) {
        super(errorHandler);
        this.mappingContext = mappingContext;
        this.sessionContext = sessionContext;
        this.indexedType = type;
        this.idAttributeOfIndexedType = idAttributeOfIndexedType;
        this.idFetchSize = idFetchSize;
        this.transactionTimeout = transactionTimeout;
        this.documentBuilderThreads = objectLoadingThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.primaryKeyStream = new ProducerConsumerQueue(1);
        this.endAllSignal = endAllSignal;
        this.producerEndSignal = new CountDownLatch(this.documentBuilderThreads);
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithErrorHandler() {
        if (!this.tasks.isEmpty()) {
            throw new AssertionFailure("BatchIndexingWorkspace instance not expected to be reused - tasks should be empty");
        }
        try {
            BatchTransactionalContext transactionalContext = new BatchTransactionalContext(this.mappingContext.getSessionFactory());
            this.startTransformationToLuceneWork();
            this.startProducingPrimaryKeys(transactionalContext);
            try {
                this.producerEndSignal.await();
                log.debugf("All work for type %s has been produced", this.indexedType.getName());
            }
            catch (InterruptedException e) {
                for (Future<?> task : this.tasks) {
                    if (task.isDone()) continue;
                    task.cancel(true);
                }
                Thread.currentThread().interrupt();
                throw log.interruptedBatchIndexingException(e);
            }
        }
        finally {
            this.endAllSignal.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProducingPrimaryKeys(BatchTransactionalContext transactionalContext) {
        OptionallyWrapInJTATransaction primaryKeyOutputter = new OptionallyWrapInJTATransaction(transactionalContext, this.getErrorHandler(), new IdentifierProducer<E, I>(this.primaryKeyStream, (SessionFactory)this.mappingContext.getSessionFactory(), this.objectLoadingBatchSize, this.indexedType, this.idAttributeOfIndexedType, this.monitor, this.getErrorHandler(), this.objectsLimit, this.idFetchSize, this.sessionContext.getTenantIdentifier()), this.transactionTimeout, this.sessionContext.getTenantIdentifier());
        ThreadPoolExecutor execIdentifiersLoader = Executors.newFixedThreadPool((int)1, (String)"identifierloader");
        try {
            this.tasks.add(execIdentifiersLoader.submit(primaryKeyOutputter));
        }
        finally {
            execIdentifiersLoader.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTransformationToLuceneWork() {
        IdentifierConsumerDocumentProducer<? super E, I> documentOutputter = new IdentifierConsumerDocumentProducer<E, I>(this.primaryKeyStream, this.monitor, this.getErrorHandler(), this.mappingContext, this.producerEndSignal, this.cacheMode, this.indexedType, this.idAttributeOfIndexedType, this.transactionTimeout, this.sessionContext.getTenantIdentifier());
        ThreadPoolExecutor execFirstLoader = Executors.newFixedThreadPool((int)this.documentBuilderThreads, (String)"entityloader");
        try {
            for (int i = 0; i < this.documentBuilderThreads; ++i) {
                this.tasks.add(execFirstLoader.submit(documentOutputter));
            }
        }
        finally {
            execFirstLoader.shutdown();
        }
    }
}

