/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.LongAdder;
import javax.persistence.LockModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import javax.transaction.TransactionManager;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.query.Query;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.massindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.mapper.orm.massindexing.monitor.MassIndexingMonitor;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class IdentifierConsumerDocumentProducer<E, I>
implements Runnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ProducerConsumerQueue<List<I>> source;
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final CacheMode cacheMode;
    private final Class<E> type;
    private final MassIndexingMonitor monitor;
    private final ErrorHandler errorHandler;
    private final SingularAttribute<? super E, I> idAttributeOfIndexedType;
    private final CountDownLatch producerEndSignal;
    private final Integer transactionTimeout;
    private final String tenantId;
    private final TransactionManager transactionManager;

    IdentifierConsumerDocumentProducer(ProducerConsumerQueue<List<I>> fromIdentifierListToEntities, MassIndexingMonitor monitor, ErrorHandler errorHandler, HibernateOrmMassIndexingMappingContext mappingContext, CountDownLatch producerEndSignal, CacheMode cacheMode, Class<E> indexedType, SingularAttribute<? super E, I> idAttributeOfIndexedType, Integer transactionTimeout, String tenantId) {
        this.source = fromIdentifierListToEntities;
        this.mappingContext = mappingContext;
        this.cacheMode = cacheMode;
        this.type = indexedType;
        this.monitor = monitor;
        this.errorHandler = errorHandler;
        this.idAttributeOfIndexedType = idAttributeOfIndexedType;
        this.producerEndSignal = producerEndSignal;
        this.transactionTimeout = transactionTimeout;
        this.tenantId = tenantId;
        this.transactionManager = ((JtaPlatform)mappingContext.getSessionFactory().getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
        log.trace("created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.trace("started");
        SessionImplementor session = (SessionImplementor)this.mappingContext.getSessionFactory().withOptions().tenantIdentifier(this.tenantId).openSession();
        session.setHibernateFlushMode(FlushMode.MANUAL);
        session.setCacheMode(this.cacheMode);
        session.setDefaultReadOnly(true);
        try {
            this.loadAllFromQueue(session);
        }
        catch (Exception exception) {
            String logMessage = log.massIndexerExceptionWhileTransformingIds();
            this.errorHandler.handleException(logMessage, (Throwable)exception);
        }
        finally {
            this.producerEndSignal.countDown();
            session.close();
        }
        log.trace("finished");
    }

    private void loadAllFromQueue(SessionImplementor session) throws Exception {
        PojoIndexer indexer = this.mappingContext.createIndexer(session, DocumentCommitStrategy.NONE);
        try {
            List<I> idList;
            do {
                if ((idList = this.source.take()) == null) continue;
                log.tracef("received list of ids %s", idList);
                this.loadList(idList, session, indexer);
            } while (idList != null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadList(List<I> listIds, SessionImplementor session, PojoIndexer indexer) throws Exception {
        try {
            this.beginTransaction((Session)session);
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.type);
            Root root = criteriaQuery.from(this.type);
            criteriaQuery.select((Selection)root);
            criteriaQuery.where((Expression)root.get(this.idAttributeOfIndexedType).in(listIds));
            Query query = session.createQuery(criteriaQuery).setCacheMode(this.cacheMode).setLockMode(LockModeType.NONE).setCacheable(false).setHibernateFlushMode(FlushMode.MANUAL).setFetchSize(listIds.size());
            this.indexAllQueue(indexer, query.getResultList());
            session.clear();
        }
        finally {
            this.rollbackTransaction(session);
        }
    }

    private void beginTransaction(Session session) throws Exception {
        if (this.transactionManager != null) {
            if (this.transactionTimeout != null) {
                this.transactionManager.setTransactionTimeout(this.transactionTimeout.intValue());
            }
            this.transactionManager.begin();
        } else {
            session.beginTransaction();
        }
    }

    private void rollbackTransaction(SessionImplementor session) {
        try {
            if (this.transactionManager != null) {
                this.transactionManager.rollback();
            } else {
                session.accessTransaction().rollback();
            }
        }
        catch (Exception e) {
            log.errorRollingBackTransaction(e.getMessage(), e);
        }
    }

    private void indexAllQueue(PojoIndexer indexer, List<E> entities) throws InterruptedException {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        this.monitor.entitiesLoaded(entities.size());
        CompletableFuture[] futures = new CompletableFuture[entities.size()];
        LongAdder failedEntitiesAdder = new LongAdder();
        for (int i = 0; i < entities.size(); ++i) {
            E entity = entities.get(i);
            futures[i] = this.index(indexer, entity);
            futures[i].exceptionally(exception -> {
                failedEntitiesAdder.increment();
                this.handleException(entity, (Throwable)exception);
                return null;
            });
        }
        ((CompletableFuture)CompletableFuture.allOf(futures).exceptionally(exception -> null)).join();
        this.monitor.documentsAdded((long)entities.size() - failedEntitiesAdder.longValue());
    }

    private CompletableFuture<?> index(PojoIndexer indexer, E entity) throws InterruptedException {
        CompletableFuture future;
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        try {
            future = indexer.add(entity);
        }
        catch (RuntimeException e) {
            CompletableFuture future2 = new CompletableFuture();
            future2.completeExceptionally(e);
            return future2;
        }
        this.monitor.documentsBuilt(1L);
        return future;
    }

    private void handleException(Object entity, Throwable e) {
        String errorMsg = log.massIndexerUnableToIndexInstance(entity.getClass().getName(), entity.toString());
        this.errorHandler.handleException(errorMsg, e);
    }
}

