/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.transaction.Synchronization;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PostTransactionWorkQueueSynchronization
implements Synchronization {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoIndexingPlan indexingPlan;
    private final Map<?, ?> indexingPlanPerTransaction;
    private final Object transactionIdentifier;
    private final AutomaticIndexingSynchronizationStrategy synchronizationStrategy;

    public PostTransactionWorkQueueSynchronization(PojoIndexingPlan indexingPlan, Map<?, ?> indexingPlanPerTransaction, Object transactionIdentifier, AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        this.indexingPlan = indexingPlan;
        this.indexingPlanPerTransaction = indexingPlanPerTransaction;
        this.transactionIdentifier = transactionIdentifier;
        this.synchronizationStrategy = synchronizationStrategy;
    }

    public void beforeCompletion() {
        log.tracef("Processing Transaction's beforeCompletion() phase: %s", this);
        this.indexingPlan.process();
    }

    public void afterCompletion(int i) {
        try {
            if (3 == i) {
                log.tracef("Processing Transaction's afterCompletion() phase for %s. Performing work.", this);
                CompletableFuture future = this.indexingPlan.execute();
                this.synchronizationStrategy.handleFuture(future);
            } else {
                log.tracef("Processing Transaction's afterCompletion() phase for %s. Cancelling work due to transaction status %d", this, i);
                this.indexingPlan.discard();
            }
        }
        finally {
            this.indexingPlanPerTransaction.remove(this.transactionIdentifier);
        }
    }
}

