/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.work.impl;

import org.hibernate.search.mapper.orm.work.SearchIndexingPlan;
import org.hibernate.search.mapper.orm.work.impl.SearchIndexingPlanContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;

public final class SearchIndexingPlanImpl
implements SearchIndexingPlan {
    private final SearchIndexingPlanContext context;

    public SearchIndexingPlanImpl(SearchIndexingPlanContext context) {
        this.context = context;
    }

    @Override
    public void addOrUpdate(Object entity) {
        this.context.getCurrentIndexingPlan(true).addOrUpdate(entity);
    }

    @Override
    public void delete(Object entity) {
        this.context.getCurrentIndexingPlan(true).delete(entity);
    }

    @Override
    public void purge(Class<?> entityClass, Object providedId) {
        this.context.getCurrentIndexingPlan(true).purge(entityClass, providedId);
    }

    @Override
    public void process() {
        PojoIndexingPlan plan = this.context.getCurrentIndexingPlan(false);
        if (plan == null) {
            return;
        }
        plan.process();
    }

    @Override
    public void execute() {
        PojoIndexingPlan plan = this.context.getCurrentIndexingPlan(false);
        if (plan == null) {
            return;
        }
        this.context.getAutomaticIndexingSynchronizationStrategy().handleFuture(plan.execute());
    }
}

