package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Locale;
import org.hibernate.SessionFactory;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.InterruptedException;
import java.lang.Exception;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.jboss.logging.BasicLogger;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.mapping.Value;
import org.hibernate.search.mapper.orm.common.EntityReference;
import java.util.Collection;
import java.lang.Throwable;
import java.lang.Class;
import java.util.List;
import java.util.Arrays;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void indexingEntities(final long count) {
        super.log.logf(FQCN, INFO, null, indexingEntities$str(), count);
    }
    protected String indexingEntities$str() {
        return "HSEARCH000027: Going to reindex %d entities";
    }
    @Override
    public final void indexingEntitiesCompleted(final long nbrOfEntities) {
        super.log.logf(FQCN, INFO, null, indexingEntitiesCompleted$str(), nbrOfEntities);
    }
    protected String indexingEntitiesCompleted$str() {
        return "HSEARCH000028: Reindexed %1$d entities";
    }
    @Override
    public final void indexingDocumentsCompleted(final long doneCount, final long elapsedMs) {
        super.log.logf(FQCN, INFO, null, indexingDocumentsCompleted$str(), doneCount, elapsedMs);
    }
    protected String indexingDocumentsCompleted$str() {
        return "HSEARCH000030: %1$d documents indexed in %2$d ms";
    }
    @Override
    public final void indexingSpeed(final float estimateSpeed, final float estimatePercentileComplete) {
        super.log.logf(FQCN, INFO, null, indexingSpeed$str(), estimateSpeed, estimatePercentileComplete);
    }
    protected String indexingSpeed$str() {
        return "HSEARCH000031: Indexing speed: %1$f documents/second; progress: %2$.2f%%";
    }
    @Override
    public final void cannotGuessTransactionStatus(final Exception e) {
        super.log.logf(FQCN, WARN, e, cannotGuessTransactionStatus$str());
    }
    protected String cannotGuessTransactionStatus$str() {
        return "HSEARCH000036: Cannot guess the Transaction Status: not starting a JTA transaction";
    }
    @Override
    public final void interruptedBatchIndexing() {
        super.log.logf(FQCN, ERROR, null, interruptedBatchIndexing$str());
    }
    protected String interruptedBatchIndexing$str() {
        return "HSEARCH000062: Mass indexing was interrupted";
    }
    @Override
    public final void errorRollingBackTransaction(final String message, final Exception e1) {
        super.log.logf(FQCN, ERROR, e1, errorRollingBackTransaction$str(), message);
    }
    protected String errorRollingBackTransaction$str() {
        return "HSEARCH000065: Error while rolling back transaction after %1$s";
    }
    protected String massIndexerOperation$str() {
        return "MassIndexer operation";
    }
    @Override
    public final String massIndexerOperation() {
        return String.format(getLoggingLocale(), massIndexerOperation$str());
    }
    protected String massIndexerIndexingInstance$str() {
        return "Indexing instance of entity '%s' during mass indexing";
    }
    @Override
    public final String massIndexerIndexingInstance(final String entityName) {
        return String.format(getLoggingLocale(), massIndexerIndexingInstance$str(), entityName);
    }
    protected String massIndexerFetchingIds$str() {
        return "Fetching identifiers of entities to index for entity '%s' during mass indexing";
    }
    @Override
    public final String massIndexerFetchingIds(final String entityName) {
        return String.format(getLoggingLocale(), massIndexerFetchingIds$str(), entityName);
    }
    protected String massIndexingLoadingAndExtractingEntityData$str() {
        return "Loading and extracting entity data for entity '%s' during mass indexing";
    }
    @Override
    public final String massIndexingLoadingAndExtractingEntityData(final String entityName) {
        return String.format(getLoggingLocale(), massIndexingLoadingAndExtractingEntityData$str(), entityName);
    }
    protected String transactionNotActiveWhileProducingIdsForBatchIndexing$str() {
        return "HSEARCH000276: No transaction is active while indexing entity type '%1$s'; Consider increasing the connection time-out";
    }
    @Override
    public final SearchException transactionNotActiveWhileProducingIdsForBatchIndexing(final Class<?> entityType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), transactionNotActiveWhileProducingIdsForBatchIndexing$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(entityType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String hibernateSearchNotInitialized$str() {
        return "HSEARCH800001: Hibernate Search was not initialized.";
    }
    @Override
    public final SearchException hibernateSearchNotInitialized() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSearchNotInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedSearchHitType$str() {
        return "HSEARCH800002: Unexpected entity type for a query hit: %1$s. Expected one of %2$s.";
    }
    @Override
    public final SearchException unexpectedSearchHitType(final Class<?> entityType, final Collection<? extends Class<?>> expectedTypes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedSearchHitType$str(), entityType, expectedTypes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAutomaticIndexingStrategyName$str() {
        return "HSEARCH800003: Invalid automatic indexing strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidAutomaticIndexingStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAutomaticIndexingStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownPathForDirtyChecking$str() {
        return "HSEARCH800007: Path '%2$s' on entity type '%1$s' cannot be resolved using Hibernate ORM metadata. Please check that this path points to a persisted value.";
    }
    @Override
    public final SearchException unknownPathForDirtyChecking(final Class<?> entityType, final PojoModelPath path, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownPathForDirtyChecking$str(), entityType, path), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unreportedPathForDirtyChecking$str() {
        return "HSEARCH800008: Path '%2$s' on entity type '%1$s' can be resolved using Hibernate ORM metadata, but points to value '%3$s' that will never be reported as dirty by Hibernate ORM. Please check that this path points to a persisted value, and in particular not an embedded property.";
    }
    @Override
    public final SearchException unreportedPathForDirtyChecking(final Class<?> entityType, final PojoModelPath path, final Value value) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unreportedPathForDirtyChecking$str(), entityType, path, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidContainerExtractorForDirtyChecking$str() {
        return "HSEARCH800009: Container value extractor with name '%2$s' cannot be applied to Hibernate ORM metadata node of type '%1$s'.";
    }
    @Override
    public final SearchException invalidContainerExtractorForDirtyChecking(final Class<?> ormMappingClass, final String extractorName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContainerExtractorForDirtyChecking$str(), ormMappingClass, extractorName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindReadableProperty$str() {
        return "HSEARCH800010: Unable to find a readable property '%2$s' on type '%1$s'.";
    }
    @Override
    public final SearchException cannotFindReadableProperty(final PojoRawTypeModel<?> typeModel, final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindReadableProperty$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), propertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String usingDifferentSessionFactories$str() {
        return "HSEARCH800011: Mapping service cannot create a SearchSession using a different session factory. Expected: '%1$s'. In use: '%2$s'.";
    }
    @Override
    public final SearchException usingDifferentSessionFactories(final SessionFactory expectedSessionFactory, final SessionFactory usedSessionFactory) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), usingDifferentSessionFactories$str(), expectedSessionFactory, usedSessionFactory));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorRetrievingPropertyTypeModel$str() {
        return "HSEARCH800012: Exception while retrieving property type model for '%1$s' on '%2$s'.";
    }
    @Override
    public final SearchException errorRetrievingPropertyTypeModel(final String propertyModelName, final PojoRawTypeModel<?> parentTypeModel, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingPropertyTypeModel$str(), propertyModelName, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(parentTypeModel)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String massIndexingThreadInterrupted$str() {
        return "HSEARCH800013: Mass indexing was interrupted; index will be left in unknown state!";
    }
    @Override
    public final SearchException massIndexingThreadInterrupted(final InterruptedException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), massIndexingThreadInterrupted$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidReflectionStrategyName$str() {
        return "HSEARCH800015: Invalid reflection strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidReflectionStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidReflectionStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hibernateSessionAccessError$str() {
        return "HSEARCH800016: Error trying to access Hibernate ORM session.";
    }
    @Override
    public final SearchException hibernateSessionAccessError(final IllegalStateException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSessionAccessError$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hibernateSessionIsClosed$str() {
        return "HSEARCH800017: Underlying Hibernate ORM Session seems to be closed.";
    }
    @Override
    public final SearchException hibernateSessionIsClosed(final IllegalStateException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSessionIsClosed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAutomaticIndexingSynchronizationStrategyName$str() {
        return "HSEARCH800018: Invalid automatic indexing synchronization strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidAutomaticIndexingSynchronizationStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAutomaticIndexingSynchronizationStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(final Class<?> entityType, final EntityLoadingCacheLookupStrategy cacheLookupStrategy) {
        super.log.logf(FQCN, DEBUG, null, skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(entityType), cacheLookupStrategy);
    }
    protected String skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str() {
        return "HSEARCH800019: The entity loader for '%1$s' will ignore the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.";
    }
    @Override
    public final void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(final Class<?> entityType) {
        super.log.logf(FQCN, DEBUG, null, skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(entityType));
    }
    protected String skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str() {
        return "HSEARCH800020: The entity loader for '%1$s' will ignore the second-level cache  even though it was instructed to use it, because caching is not enabled for this entity type.";
    }
    protected String hibernateSessionFactoryAccessError$str() {
        return "HSEARCH800021: Error trying to access Hibernate ORM session factory.";
    }
    @Override
    public final SearchException hibernateSessionFactoryAccessError(final IllegalStateException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSessionFactoryAccessError$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexingFailure$str() {
        return "HSEARCH800022: Indexing failure: %1$s.\nThe following entities may not have been updated correctly in the index: %2$s.";
    }
    @Override
    public final SearchException indexingFailure(final String causeMessage, final List<EntityReference> failingEntities, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexingFailure$str(), causeMessage, failingEntities), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String automaticIndexing$str() {
        return "Automatic indexing of Hibernate ORM entities";
    }
    @Override
    public final String automaticIndexing() {
        return String.format(getLoggingLocale(), automaticIndexing$str());
    }
    protected String synchronizationBeforeTransactionFailure$str() {
        return "HSEARCH800023: Automatic indexing failed before transaction completion: %1$s";
    }
    @Override
    public final SearchException synchronizationBeforeTransactionFailure(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), synchronizationBeforeTransactionFailure$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String synchronizationAfterTransactionFailure$str() {
        return "HSEARCH800024: Automatic indexing failed after transaction completion: %1$s";
    }
    @Override
    public final SearchException synchronizationAfterTransactionFailure(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), synchronizationAfterTransactionFailure$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String massIndexingTransactionHandlingException$str() {
        return "HSEARCH800025: Exception while handling transactions: %1$s";
    }
    @Override
    public final SearchException massIndexingTransactionHandlingException(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), massIndexingTransactionHandlingException$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String massIndexingEntityFailures$str() {
        return "HSEARCH800026: %1$s entities could not be indexed. See the logs for details. First failure on entity '%2$s': %3$s";
    }
    @Override
    public final SearchException massIndexingEntityFailures(final long finalFailureCount, final EntityReference firstFailureEntity, final String firstFailureMessage, final Throwable firstFailure) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), massIndexingEntityFailures$str(), finalFailureCount, firstFailureEntity, firstFailureMessage), firstFailure);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
