/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.ClearEventListener;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.mapper.orm.automaticindexing.AutomaticIndexingStrategyName;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmIntegrationBooterImpl;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchSessionFactoryObserver;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmMapperSettings;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerContextProvider;
import org.hibernate.search.mapper.orm.event.impl.HibernateSearchEventListener;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateSearchContextProviderService;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class HibernateSearchIntegrator
implements Integrator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Boolean> ENABLED = ConfigurationProperty.forKey((String)"hibernate.search.enabled").asBoolean().withDefault((Object)true).build();
    private static final ConfigurationProperty<AutomaticIndexingStrategyName> AUTOMATIC_INDEXING_STRATEGY = ConfigurationProperty.forKey((String)"hibernate.search.automatic_indexing.strategy").as(AutomaticIndexingStrategyName.class, AutomaticIndexingStrategyName::of).withDefault((Object)HibernateOrmMapperSettings.Defaults.AUTOMATIC_INDEXING_STRATEGY).build();
    private static final ConfigurationProperty<Boolean> DIRTY_CHECK_ENABLED = ConfigurationProperty.forKey((String)"hibernate.search.automatic_indexing.enable_dirty_check").asBoolean().withDefault((Object)true).build();

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        ConfigurationPropertyChecker propertyChecker = ConfigurationPropertyChecker.create();
        ConfigurationPropertySource propertySource = HibernateOrmIntegrationBooterImpl.getPropertySource((ServiceRegistry)serviceRegistry, propertyChecker);
        if (!((Boolean)ENABLED.get(propertySource)).booleanValue()) {
            log.debug("Hibernate Search is disabled through configuration properties.");
            return;
        }
        BootstrapContext bootstrapContext = ((MetadataImplementor)metadata).getTypeConfiguration().getMetadataBuildingContext().getBootstrapContext();
        HibernateOrmIntegrationBooterImpl booter = new HibernateOrmIntegrationBooterImpl(metadata, bootstrapContext, propertySource, propertyChecker);
        CompletableFuture<SessionFactoryImplementor> sessionFactoryCreatedFuture = new CompletableFuture<SessionFactoryImplementor>();
        CompletableFuture sessionFactoryClosingFuture = new CompletableFuture();
        CompletableFuture<HibernateSearchContextProviderService> contextFuture = booter.orchestrateBootAndShutdown(sessionFactoryCreatedFuture, sessionFactoryClosingFuture);
        HibernateSearchSessionFactoryObserver observer = new HibernateSearchSessionFactoryObserver(sessionFactoryCreatedFuture, sessionFactoryClosingFuture, contextFuture);
        sessionFactory.addObserver((SessionFactoryObserver)observer);
        AutomaticIndexingStrategyName automaticIndexingStrategyName = (AutomaticIndexingStrategyName)((Object)AUTOMATIC_INDEXING_STRATEGY.get(propertySource));
        if (AutomaticIndexingStrategyName.SESSION.equals((Object)automaticIndexingStrategyName)) {
            log.debug("Hibernate Search event listeners activated");
            HibernateSearchEventListener hibernateSearchEventListener = new HibernateSearchEventListener((CompletableFuture<? extends HibernateOrmListenerContextProvider>)contextFuture.thenApply(Supplier::get), (Boolean)DIRTY_CHECK_ENABLED.get(propertySource));
            this.registerHibernateSearchEventListener(hibernateSearchEventListener, serviceRegistry);
        } else {
            log.debug("Hibernate Search event listeners deactivated");
        }
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private void registerHibernateSearchEventListener(HibernateSearchEventListener eventListener, SessionFactoryServiceRegistry serviceRegistry) {
        EventListenerRegistry listenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy((DuplicationStrategy)new KeepIfSameClassDuplicationStrategy(HibernateSearchEventListener.class));
        listenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_RECREATE, (Object[])new PostCollectionRecreateEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_REMOVE, (Object[])new PostCollectionRemoveEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_UPDATE, (Object[])new PostCollectionUpdateEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.FLUSH, (Object[])new FlushEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.AUTO_FLUSH, (Object[])new AutoFlushEventListener[]{eventListener});
        listenerRegistry.appendListeners(EventType.CLEAR, (Object[])new ClearEventListener[]{eventListener});
    }

    public static class KeepIfSameClassDuplicationStrategy
    implements DuplicationStrategy {
        private final Class<?> checkClass;

        public KeepIfSameClassDuplicationStrategy(Class<?> checkClass) {
            this.checkClass = checkClass;
        }

        public boolean areMatch(Object listener, Object original) {
            return this.checkClass == original.getClass() && this.checkClass == listener.getClass();
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    }
}

