/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.Type;
import org.hibernate.AssertionFailure;
import org.hibernate.Metamodel;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderFactory;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoadingCacheLookupStrategyImplementor;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.search.loading.impl.PersistenceContextLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.impl.PersistenceContextThenSecondLevelCacheLookupStrategy;

public class HibernateOrmByIdEntityLoader<E>
implements HibernateOrmComposableEntityLoader<E> {
    private final Session session;
    private final Class<E> entityType;
    private final EntityLoadingCacheLookupStrategyImplementor<E> cacheLookupStrategyImplementor;
    private final MutableEntityLoadingOptions loadingOptions;

    public static <E> EntityLoaderFactory factory(SessionFactoryImplementor sessionFactory, Class<E> entityType) {
        return new Factory(HibernateOrmByIdEntityLoader.toRootEntityClass(sessionFactory, entityType));
    }

    private HibernateOrmByIdEntityLoader(Class<E> entityType, Session session, EntityLoadingCacheLookupStrategyImplementor<E> cacheLookupStrategyImplementor, MutableEntityLoadingOptions loadingOptions) {
        this.entityType = entityType;
        this.session = session;
        this.cacheLookupStrategyImplementor = cacheLookupStrategyImplementor;
        this.loadingOptions = loadingOptions;
    }

    @Override
    public List<E> loadBlocking(List<EntityReference> references) {
        if (this.cacheLookupStrategyImplementor == null) {
            return this.loadEntities(references);
        }
        return HibernateOrmComposableEntityLoader.super.loadBlocking(references);
    }

    @Override
    public void loadBlocking(List<EntityReference> references, Map<? super EntityReference, ? super E> entitiesByReference) {
        List<EntityReference> missingFromCacheReferences = this.loadBlockingFromCache(references, entitiesByReference);
        if (missingFromCacheReferences.isEmpty()) {
            return;
        }
        List<E> loadedEntities = this.loadEntities(missingFromCacheReferences);
        Iterator<EntityReference> referencesIterator = missingFromCacheReferences.iterator();
        Iterator<E> loadedEntityIterator = loadedEntities.iterator();
        while (referencesIterator.hasNext()) {
            EntityReference reference = referencesIterator.next();
            E loadedEntity = loadedEntityIterator.next();
            if (loadedEntity == null) continue;
            entitiesByReference.put(reference, loadedEntity);
        }
    }

    private List<EntityReference> loadBlockingFromCache(List<EntityReference> references, Map<? super EntityReference, ? super E> entitiesByReference) {
        if (this.cacheLookupStrategyImplementor == null) {
            return references;
        }
        ArrayList<EntityReference> missingFromCacheReferences = new ArrayList<EntityReference>(references.size());
        for (EntityReference reference : references) {
            Object entityId = reference.getId();
            E loadedEntity = this.cacheLookupStrategyImplementor.lookup(entityId);
            if (loadedEntity == null) {
                missingFromCacheReferences.add(reference);
                continue;
            }
            if (HibernateOrmByIdEntityLoader.hasExpectedType(reference, loadedEntity)) {
                entitiesByReference.put(reference, loadedEntity);
                continue;
            }
            entitiesByReference.put(reference, null);
        }
        return missingFromCacheReferences;
    }

    private List<E> loadEntities(List<EntityReference> references) {
        ArrayList<Serializable> ids = new ArrayList<Serializable>(references.size());
        for (EntityReference reference : references) {
            ids.add((Serializable)reference.getId());
        }
        List loadedEntities = this.getMultiAccess().multiLoad(ids);
        for (int i = 0; i < references.size(); ++i) {
            Object loadedEntity;
            EntityReference reference = references.get(i);
            if (HibernateOrmByIdEntityLoader.hasExpectedType(reference, loadedEntity = loadedEntities.get(i))) continue;
            loadedEntities.set(i, null);
        }
        return loadedEntities;
    }

    private MultiIdentifierLoadAccess<E> getMultiAccess() {
        MultiIdentifierLoadAccess multiAccess = this.session.byMultipleIds(this.entityType);
        multiAccess.withBatchSize(this.loadingOptions.getFetchSize());
        return multiAccess;
    }

    private static boolean hasExpectedType(EntityReference reference, Object loadedEntity) {
        return reference.getType().isInstance(loadedEntity);
    }

    private static Class<?> toRootEntityClass(SessionFactoryImplementor sessionFactory, Class<?> entityClass) {
        MetamodelImplementor metamodel = sessionFactory.getMetamodel();
        String rootEntityName = metamodel.entityPersister(entityClass).getRootEntityName();
        return metamodel.entityPersister(rootEntityName).getMappedClass();
    }

    private static class Factory
    implements EntityLoaderFactory {
        private final Class<?> rootEntityType;

        private Factory(Class<?> rootEntityType) {
            this.rootEntityType = rootEntityType;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Factory other = (Factory)obj;
            return this.rootEntityType.equals(other.rootEntityType);
        }

        @Override
        public int hashCode() {
            return this.rootEntityType.hashCode();
        }

        @Override
        public <E> HibernateOrmComposableEntityLoader<E> create(Class<E> targetEntityType, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            if (!this.rootEntityType.isAssignableFrom(targetEntityType)) {
                throw new AssertionFailure("The targeted entity type is not a subclass of the expected root entity type. There is a bug in Hibernate Search, please report it. Expected root entity type: " + this.rootEntityType + " Targeted entity type: " + targetEntityType);
            }
            return this.doCreate(targetEntityType, session, cacheLookupStrategy, loadingOptions);
        }

        public <E2> HibernateOrmComposableEntityLoader<? extends E2> create(List<Class<? extends E2>> targetEntityTypes, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            Class<?> commonSuperClass = Factory.toMostSpecificCommonEntitySuperClass((SessionFactory)session.getSessionFactory(), targetEntityTypes);
            if (!this.rootEntityType.isAssignableFrom(commonSuperClass)) {
                throw new AssertionFailure("Some types among the targeted entity types are not subclasses of the expected root entity type. There is a bug in Hibernate Search, please report it. Expected root entity type: " + this.rootEntityType + " Targeted entity types: " + targetEntityTypes);
            }
            HibernateOrmComposableEntityLoader<?> result = this.doCreate(commonSuperClass, session, cacheLookupStrategy, loadingOptions);
            return result;
        }

        private <E> HibernateOrmComposableEntityLoader<E> doCreate(Class<E> targetEntityType, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            EntityLoadingCacheLookupStrategyImplementor<E> cacheLookupStrategyImplementor;
            switch (cacheLookupStrategy) {
                case SKIP: {
                    cacheLookupStrategyImplementor = null;
                    break;
                }
                case PERSISTENCE_CONTEXT: {
                    cacheLookupStrategyImplementor = PersistenceContextLookupStrategy.create(targetEntityType, session);
                    break;
                }
                case PERSISTENCE_CONTEXT_THEN_SECOND_LEVEL_CACHE: {
                    cacheLookupStrategyImplementor = PersistenceContextThenSecondLevelCacheLookupStrategy.create(targetEntityType, session);
                    break;
                }
                default: {
                    throw new AssertionFailure("Unexpected cache lookup strategy: " + (Object)((Object)cacheLookupStrategy));
                }
            }
            return new HibernateOrmByIdEntityLoader(targetEntityType, (Session)session, cacheLookupStrategyImplementor, loadingOptions);
        }

        private static Class<?> toMostSpecificCommonEntitySuperClass(SessionFactory sessionFactory, Iterable<? extends Class<?>> targetedClasses) {
            Metamodel metamodel = sessionFactory.getMetamodel();
            IdentifiableType<?> result = null;
            for (Class<?> targetedClass : targetedClasses) {
                IdentifiableType<?> type = metamodel.entity(targetedClass);
                if (result == null) {
                    result = type;
                    continue;
                }
                result = Factory.toMostSpecificCommonEntitySuperType(result, type);
            }
            return result.getJavaType();
        }

        private static IdentifiableType<?> toMostSpecificCommonEntitySuperType(IdentifiableType<?> type1, IdentifiableType<?> type2) {
            IdentifiableType superType = type1;
            while (!superType.getJavaType().isAssignableFrom(type2.getJavaType()) || !Type.PersistenceType.ENTITY.equals((Object)superType.getPersistenceType())) {
                superType = superType.getSupertype();
            }
            return superType;
        }
    }
}

