/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.work.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.backend.common.spi.DocumentReferenceConverter;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.work.SearchIndexingPlanExecutionReport;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Throwables;

public class SearchIndexingPlanExecutionReportImpl
implements SearchIndexingPlanExecutionReport {
    private Throwable throwable;
    private List<EntityReference> failingEntities;

    public static Function<IndexIndexingPlanExecutionReport, SearchIndexingPlanExecutionReport> factory(DocumentReferenceConverter<EntityReference> referenceConverter) {
        return report -> SearchIndexingPlanExecutionReportImpl.convert(referenceConverter, report);
    }

    private SearchIndexingPlanExecutionReportImpl(Throwable throwable, List<EntityReference> failingEntities) {
        this.throwable = throwable;
        this.failingEntities = failingEntities == null ? Collections.emptyList() : Collections.unmodifiableList(failingEntities);
    }

    @Override
    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    @Override
    public List<EntityReference> getFailingEntities() {
        return this.failingEntities;
    }

    private static SearchIndexingPlanExecutionReport convert(DocumentReferenceConverter<EntityReference> referenceConverter, IndexIndexingPlanExecutionReport indexReport) {
        Throwable throwable = indexReport.getThrowable().orElse(null);
        if (throwable == null && !indexReport.getFailingDocuments().isEmpty()) {
            throwable = new AssertionFailure("Unknown throwable: missing throwable when reporting the failure. There is probably a bug in Hibernate Search, please report it.");
        }
        ArrayList<EntityReference> failingEntities = null;
        for (DocumentReference failingDocument : indexReport.getFailingDocuments()) {
            if (failingEntities == null) {
                failingEntities = new ArrayList<EntityReference>();
            }
            EntityReference reference = SearchIndexingPlanExecutionReportImpl.convertOrFail(referenceConverter, failingDocument, throwable);
            failingEntities.add(reference);
        }
        return new SearchIndexingPlanExecutionReportImpl(throwable, failingEntities);
    }

    private static EntityReference convertOrFail(DocumentReferenceConverter<EntityReference> referenceConverter, DocumentReference documentReference, Throwable throwable) {
        try {
            return (EntityReference)referenceConverter.fromDocumentReference(documentReference);
        }
        catch (RuntimeException e) {
            throwable.addSuppressed(e);
            throw Throwables.toRuntimeException((Throwable)throwable);
        }
    }
}

