/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.automaticindexing.AutomaticIndexingSynchronizationStrategyName;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmMapperSettings;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerContextProvider;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;
import org.hibernate.search.mapper.orm.mapping.context.impl.HibernateOrmMappingContextImpl;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmTypeContextContainer;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateSearchContextProviderService;
import org.hibernate.search.mapper.orm.scope.SearchScope;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeMappingContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeSessionContext;
import org.hibernate.search.mapper.orm.scope.impl.SearchScopeImpl;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.session.impl.ConfiguredAutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.mapping.context.spi.AbstractPojoBackendMappingContext;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmMapping
extends AbstractPojoMappingImplementor<HibernateOrmMapping>
implements SearchMapping,
HibernateOrmListenerContextProvider,
HibernateOrmScopeMappingContext,
HibernateOrmSearchSessionMappingContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<AutomaticIndexingSynchronizationStrategyName> AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY = ConfigurationProperty.forKey((String)"automatic_indexing.synchronization.strategy").as(AutomaticIndexingSynchronizationStrategyName.class, AutomaticIndexingSynchronizationStrategyName::of).withDefault((Object)HibernateOrmMapperSettings.Defaults.AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY).build();
    private static final ConfigurationProperty<EntityLoadingCacheLookupStrategy> QUERY_LOADING_CACHE_LOOKUP_STRATEGY = ConfigurationProperty.forKey((String)"query.loading.cache_lookup.strategy").as(EntityLoadingCacheLookupStrategy.class, EntityLoadingCacheLookupStrategy::of).withDefault((Object)HibernateOrmMapperSettings.Defaults.QUERY_LOADING_CACHE_LOOKUP_STRATEGY).build();
    private static final ConfigurationProperty<Integer> QUERY_LOADING_FETCH_SIZE = ConfigurationProperty.forKey((String)"query.loading.fetch_size").asInteger().withDefault((Object)100).build();
    private final HibernateOrmMappingContextImpl backendMappingContext;
    private final HibernateOrmTypeContextContainer typeContextContainer;
    private final AutomaticIndexingSynchronizationStrategy synchronizationStrategy;
    private final EntityLoadingCacheLookupStrategy cacheLookupStrategy;
    private final int fetchSize;

    public static MappingImplementor<HibernateOrmMapping> create(PojoMappingDelegate mappingDelegate, HibernateOrmTypeContextContainer typeContextContainer, SessionFactoryImplementor sessionFactory, ConfigurationPropertySource propertySource) {
        AutomaticIndexingSynchronizationStrategy synchronizationStrategy;
        AutomaticIndexingSynchronizationStrategyName synchronizationStrategyName = (AutomaticIndexingSynchronizationStrategyName)((Object)AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY.get(propertySource));
        switch (synchronizationStrategyName) {
            case QUEUED: {
                synchronizationStrategy = AutomaticIndexingSynchronizationStrategy.queued();
                break;
            }
            case COMMITTED: {
                synchronizationStrategy = AutomaticIndexingSynchronizationStrategy.committed();
                break;
            }
            case SEARCHABLE: {
                synchronizationStrategy = AutomaticIndexingSynchronizationStrategy.searchable();
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected automatic indexing synchronization strategy name: " + (Object)((Object)synchronizationStrategyName));
            }
        }
        log.defaultAutomaticIndexingSynchronizationStrategy((Object)synchronizationStrategyName);
        EntityLoadingCacheLookupStrategy cacheLookupStrategy = (EntityLoadingCacheLookupStrategy)((Object)QUERY_LOADING_CACHE_LOOKUP_STRATEGY.get(propertySource));
        int fetchSize = (Integer)QUERY_LOADING_FETCH_SIZE.get(propertySource);
        return new HibernateOrmMapping(mappingDelegate, typeContextContainer, sessionFactory, synchronizationStrategy, cacheLookupStrategy, fetchSize);
    }

    private HibernateOrmMapping(PojoMappingDelegate mappingDelegate, HibernateOrmTypeContextContainer typeContextContainer, SessionFactoryImplementor sessionFactory, AutomaticIndexingSynchronizationStrategy synchronizationStrategy, EntityLoadingCacheLookupStrategy cacheLookupStrategy, int fetchSize) {
        super(mappingDelegate);
        this.typeContextContainer = typeContextContainer;
        this.backendMappingContext = new HibernateOrmMappingContextImpl(sessionFactory);
        this.synchronizationStrategy = synchronizationStrategy;
        this.cacheLookupStrategy = cacheLookupStrategy;
        this.fetchSize = fetchSize;
    }

    @Override
    public <T> SearchScope<T> scope(Collection<? extends Class<? extends T>> types) {
        return this.createScope(types);
    }

    @Override
    public <T> SearchScope<T> scope(Class<T> expectedSuperType, Collection<String> entityNames) {
        return this.createScope(expectedSuperType, entityNames);
    }

    @Override
    public EntityManagerFactory toEntityManagerFactory() {
        return this.backendMappingContext.getSessionFactory();
    }

    @Override
    public SessionFactory toOrmSessionFactory() {
        return this.backendMappingContext.getSessionFactory();
    }

    @Override
    public IndexManager getIndexManager(String indexName) {
        return this.getSearchIntegration().getIndexManager(indexName);
    }

    @Override
    public Backend getBackend(String backendName) {
        return this.getSearchIntegration().getBackend(backendName);
    }

    public HibernateOrmMapping toConcreteType() {
        return this;
    }

    @Override
    public PojoIndexer createIndexer(SessionImplementor sessionImplementor, DocumentCommitStrategy commitStrategy) {
        return HibernateOrmSearchSession.get(this, sessionImplementor).createIndexer(commitStrategy);
    }

    @Override
    public EntityLoadingCacheLookupStrategy getCacheLookupStrategy() {
        return this.cacheLookupStrategy;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.backendMappingContext.getSessionFactory();
    }

    @Override
    public ThreadPoolProvider getThreadPoolProvider() {
        return this.getDelegate().getThreadPoolProvider();
    }

    @Override
    public FailureHandler getFailureHandler() {
        return this.getDelegate().getFailureHandler();
    }

    @Override
    public HibernateOrmScopeSessionContext getSessionContext(EntityManager entityManager) {
        return HibernateOrmSearchSession.get(this, HibernateOrmUtils.toSessionImplementor(entityManager));
    }

    @Override
    public DetachedBackendSessionContext getDetachedBackendSessionContext(String tenantId) {
        return DetachedBackendSessionContext.of((BackendMappingContext)this.backendMappingContext, (String)tenantId);
    }

    @Override
    public PojoIndexingPlan getCurrentIndexingPlan(SessionImplementor session, boolean createIfDoesNotExist) {
        return HibernateOrmSearchSession.get(this, session).getCurrentIndexingPlan(createIfDoesNotExist);
    }

    @Override
    public ConfiguredAutomaticIndexingSynchronizationStrategy getCurrentAutomaticIndexingSynchronizationStrategy(SessionImplementor session) {
        return HibernateOrmSearchSession.get(this, session).getConfiguredAutomaticIndexingSynchronizationStrategy();
    }

    @Override
    public HibernateOrmTypeContextContainer getTypeContextProvider() {
        return this.typeContextContainer;
    }

    @Override
    public HibernateOrmMappingContextImpl getBackendMappingContext() {
        return this.backendMappingContext;
    }

    @Override
    public <T> SearchScopeImpl<T> createScope(Collection<? extends Class<? extends T>> classes) {
        ArrayList<PojoRawTypeIdentifier<T>> typeIdentifiers = new ArrayList<PojoRawTypeIdentifier<T>>(classes.size());
        for (Class<T> clazz : classes) {
            typeIdentifiers.add(this.typeContextContainer.getTypeIdentifierByJavaClass(clazz));
        }
        return this.doCreateScope(typeIdentifiers);
    }

    @Override
    public <T> SearchScopeImpl<T> createScope(Class<T> expectedSuperType, Collection<String> entityNames) {
        ArrayList<PojoRawTypeIdentifier<T>> typeIdentifiers = new ArrayList<PojoRawTypeIdentifier<T>>(entityNames.size());
        for (String entityName : entityNames) {
            typeIdentifiers.add(this.getEntityTypeIdentifier(expectedSuperType, entityName));
        }
        return this.doCreateScope(typeIdentifiers);
    }

    @Override
    public HibernateOrmSearchSession.HibernateOrmSearchSessionBuilder createSessionBuilder(SessionImplementor sessionImplementor) {
        SessionFactoryImplementor expectedSessionFactory = this.backendMappingContext.getSessionFactory();
        SessionFactoryImplementor givenSessionFactory = sessionImplementor.getSessionFactory();
        if (!givenSessionFactory.equals(expectedSessionFactory)) {
            throw log.usingDifferentSessionFactories((SessionFactory)expectedSessionFactory, (SessionFactory)givenSessionFactory);
        }
        return new HibernateOrmSearchSession.HibernateOrmSearchSessionBuilder(this.getDelegate(), this, this.typeContextContainer, sessionImplementor, this.synchronizationStrategy);
    }

    private SearchIntegration getSearchIntegration() {
        return HibernateSearchContextProviderService.get(this.getSessionFactory()).getIntegration();
    }

    private <T> PojoRawTypeIdentifier<? extends T> getEntityTypeIdentifier(Class<T> expectedSuperType, String entityName) {
        PojoRawTypeIdentifier<?> typeIdentifier = this.typeContextContainer.getTypeIdentifierByEntityName(entityName);
        Class actualJavaType = typeIdentifier.getJavaClass();
        if (!expectedSuperType.isAssignableFrom(actualJavaType)) {
            throw log.invalidEntitySuperType(entityName, expectedSuperType, actualJavaType);
        }
        PojoRawTypeIdentifier<?> castedTypeIdentifier = typeIdentifier;
        return castedTypeIdentifier;
    }

    private <T> SearchScopeImpl<T> doCreateScope(Collection<PojoRawTypeIdentifier<? extends T>> typeIdentifiers) {
        PojoScopeDelegate scopeDelegate = this.getDelegate().createPojoScope((AbstractPojoBackendMappingContext)this.backendMappingContext, typeIdentifiers, this.typeContextContainer::getIndexedByExactType);
        return new SearchScopeImpl(this, scopeDelegate);
    }
}

