/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmAssociationEmbeddedMetadataContributor;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmAssociationInverseSideMetadataContributor;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmEntityTypeMetadataContributor;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmJpaColumnScaleContributor;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.mapping.building.spi.ErrorCollectingPojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

public final class HibernateOrmMetatadaContributor
implements PojoMappingConfigurationContributor {
    private final HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider;
    private final HibernateOrmBootstrapIntrospector introspector;

    HibernateOrmMetatadaContributor(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider, HibernateOrmBootstrapIntrospector introspector) {
        this.basicTypeMetadataProvider = basicTypeMetadataProvider;
        this.introspector = introspector;
    }

    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        PropertyDelegatesCollector delegatesCollector = new PropertyDelegatesCollector();
        for (PersistentClass persistentClass : this.basicTypeMetadataProvider.getPersistentClasses()) {
            Class clazz = persistentClass.getMappedClass();
            PojoRawTypeModel typeModel = persistentClass.hasPojoRepresentation() ? this.introspector.getTypeModel(clazz) : this.introspector.getTypeModel(persistentClass.getEntityName());
            this.collectPropertyDelegates(delegatesCollector, typeModel, persistentClass.getPropertyIterator());
            String identifierPropertyName = persistentClass.getIdentifierProperty().getName();
            List<PojoTypeMetadataContributor> delegates = delegatesCollector.buildAndRemove(typeModel);
            configurationCollector.collectContributor((MappableTypeModel)typeModel, (Object)new ErrorCollectingPojoTypeMetadataContributor().add((PojoTypeMetadataContributor)new HibernateOrmEntityTypeMetadataContributor(typeModel.getTypeIdentifier(), persistentClass, identifierPropertyName)).addAll(delegates));
        }
        for (Map.Entry entry : delegatesCollector.buildRemaining().entrySet()) {
            PojoRawTypeModel typeModel = (PojoRawTypeModel)entry.getKey();
            List delegates = (List)entry.getValue();
            if (delegates.isEmpty()) continue;
            configurationCollector.collectContributor((MappableTypeModel)typeModel, (Object)new ErrorCollectingPojoTypeMetadataContributor().addAll((Collection)delegates));
        }
    }

    private void collectPropertyDelegates(PropertyDelegatesCollector collector, PojoRawTypeModel<?> typeModel, Iterator propertyIterator) {
        collector.markAsSeen(typeModel);
        ArrayList<Property> properties = new ArrayList<Property>();
        while (propertyIterator.hasNext()) {
            properties.add((Property)propertyIterator.next());
        }
        properties.sort(Comparator.comparing(Property::getName));
        for (Property property : properties) {
            this.collectPropertyMetadataContributors(collector, typeModel, property);
        }
    }

    private void collectPropertyMetadataContributors(PropertyDelegatesCollector collector, PojoRawTypeModel<?> typeModel, Property property) {
        Value value = property.getValue();
        if (value instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collectionValue = (org.hibernate.mapping.Collection)value;
            Value element = collectionValue.getElement();
            String referencedEntityName = this.getReferencedEntityName(element);
            String mappedByPath = collectionValue.getMappedByProperty();
            if (referencedEntityName != null && mappedByPath != null && !mappedByPath.isEmpty()) {
                collector.collect(typeModel, new HibernateOrmAssociationInverseSideMetadataContributor(property.getName(), this.getExtractorPath((Value)collectionValue), this.resolveMappedByPath(referencedEntityName, mappedByPath)));
            }
        } else if (value instanceof ToOne) {
            ToOne toOneValue = (ToOne)value;
            String referencedEntityName = toOneValue.getReferencedEntityName();
            String mappedByPath = toOneValue.getReferencedPropertyName();
            if (mappedByPath != null && !mappedByPath.isEmpty()) {
                collector.collect(typeModel, new HibernateOrmAssociationInverseSideMetadataContributor(property.getName(), this.getExtractorPath((Value)toOneValue), this.resolveMappedByPath(referencedEntityName, mappedByPath)));
            }
        } else if (value instanceof Component) {
            collector.collect(typeModel, new HibernateOrmAssociationEmbeddedMetadataContributor(property.getName(), this.getExtractorPath(value)));
            Component componentValue = (Component)value;
            PojoRawTypeModel componentTypeModel = componentValue.isDynamic() ? this.introspector.getTypeModel(componentValue.getRoleName()) : this.introspector.getTypeModel(componentValue.getComponentClass());
            if (!collector.hasSeen(componentTypeModel)) {
                this.collectPropertyDelegates(collector, componentTypeModel, componentValue.getPropertyIterator());
            }
        } else if (value instanceof SimpleValue) {
            this.collectScaleContributor(collector, typeModel, property, value);
        }
    }

    private void collectScaleContributor(PropertyDelegatesCollector collector, PojoRawTypeModel<?> typeModel, Property property, Value value) {
        Iterator ci = value.getColumnIterator();
        while (ci.hasNext()) {
            Selectable selectable = (Selectable)ci.next();
            if (!(selectable instanceof Column)) continue;
            int scale = ((Column)selectable).getScale();
            HibernateOrmJpaColumnScaleContributor scaleContributor = new HibernateOrmJpaColumnScaleContributor(property.getName(), this.getExtractorPath(value), scale);
            collector.collect(typeModel, scaleContributor);
        }
    }

    private String getReferencedEntityName(Value element) {
        if (element instanceof OneToMany) {
            return ((OneToMany)element).getReferencedEntityName();
        }
        if (element instanceof ToOne) {
            return ((ToOne)element).getReferencedEntityName();
        }
        return null;
    }

    private PojoModelPathValueNode resolveMappedByPath(String inverseSideEntity, String mappedByPath) {
        StringTokenizer tokenizer = new StringTokenizer(mappedByPath, ".", false);
        String rootPropertyName = tokenizer.nextToken();
        PojoModelPath.Builder inverseSidePathBuilder = PojoModelPath.builder().property(rootPropertyName);
        Property property = this.basicTypeMetadataProvider.getPersistentClass(inverseSideEntity).getProperty(rootPropertyName);
        do {
            Value value = property.getValue();
            inverseSidePathBuilder.value(this.getExtractorPath(value));
            if (tokenizer.hasMoreTokens()) {
                Component component = (Component)value;
                String propertyName = tokenizer.nextToken();
                property = component.getProperty(propertyName);
                inverseSidePathBuilder.property(propertyName);
                continue;
            }
            property = null;
        } while (property != null);
        return inverseSidePathBuilder.toValuePath();
    }

    private ContainerExtractorPath getExtractorPath(Value value) {
        if (value instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collectionValue = (org.hibernate.mapping.Collection)value;
            String extractorName = this.getExtractorName(collectionValue);
            return ContainerExtractorPath.explicitExtractor((String)extractorName);
        }
        return ContainerExtractorPath.noExtractors();
    }

    private String getExtractorName(org.hibernate.mapping.Collection collectionValue) {
        if (collectionValue instanceof Array) {
            return "array";
        }
        if (collectionValue instanceof Map) {
            return "map-value";
        }
        return "collection";
    }

    private static class PropertyDelegatesCollector {
        private final java.util.Map<PojoRawTypeModel<?>, List<PojoTypeMetadataContributor>> result = new LinkedHashMap();

        private PropertyDelegatesCollector() {
        }

        public void markAsSeen(PojoRawTypeModel<?> typeModel) {
            this.getList(typeModel);
        }

        public boolean hasSeen(PojoRawTypeModel<?> typeModel) {
            return this.result.containsKey(typeModel);
        }

        public void collect(PojoRawTypeModel<?> typeModel, PojoTypeMetadataContributor contributor) {
            this.getList(typeModel).add(contributor);
        }

        public List<PojoTypeMetadataContributor> buildAndRemove(PojoRawTypeModel<?> typeModel) {
            List<PojoTypeMetadataContributor> built = this.getList(typeModel);
            this.result.remove(typeModel);
            return built;
        }

        public java.util.Map<PojoRawTypeModel<?>, List<PojoTypeMetadataContributor>> buildRemaining() {
            return this.result;
        }

        private List<PojoTypeMetadataContributor> getList(PojoRawTypeModel<?> typeModel) {
            return this.result.computeIfAbsent(typeModel, ignored -> new ArrayList());
        }
    }
}

